		ORIG 8000h

;Definição de variáveis		
		POSICAO_ATUAL WORD 0      ;Coord. posição atual (mm)em 8000h
		POSICAO_DESTINO WORD 0    ;Coord. posição destino (mm) em 8001h
		_SENTIDO_MOVIMENTO WORD 0 ;0 = esquerda, 1 = direita, em 8002h


;Definição de constantes
		IO_DIRECAO EQU FFF8h		  ;Endereços usado nas rotinas fornecidas
		IO_SENSOR EQU FFF9h
		SP_INICIAL EQU FDFFh	  ;
		LIMITE_MIN EQU 0		  
		LIMITE_MAX EQU 100
		DESTINOS STR 30,10,50,115,50 ;Sequência de posições absolutas, pe-
								  ;núltima fora dos limites, e uma 

		ORIG 0000h
				
MAIN:	MOV R2, SP_INICIAL
		MOV SP, R2
		CALL INICIAR_SISTEMA	  ;(alínea a)
		;CALL LEITURA_POSICOES    ;(alínea b)
		;CALL MOVIMENTO			  ;(Alinea c)
		CALL PROCESSA_DESTINOS	  ;Inicia processo de movimentos pedidos
								  ;(alínea d)
		JMP FIM

;Processo de calibragem do sistema (alínea a)						
INICIAR_SISTEMA:PUSH R1
		MOV R1, R0				  ;Sentido de rotação p/ esquerda
		CALL SET_DIRECAO

POSICAO_INICIAL:CALL IMPULSO
		CALL LE_SENSOR
		CMP R1, R0
		BR.Z POSICAO_INICIAL
		MOV M[POSICAO_ATUAL], R0
		POP R1
		RET

;Processo de verificação dos limites (alínea b)
LEITURA_POSICOES: MOV R1, M[POSICAO_ATUAL]
		MOV R2, M[POSICAO_DESTINO]
		CALL VERIFICA_LIMITES 
		RET
	 
VERIFICA_LIMITES: CMP R1, LIMITE_MIN
		BR.N MOVIMENTO_IMPOSSIVEL
		CMP R1, LIMITE_MAX
		BR.P MOVIMENTO_IMPOSSIVEL

		CMP R2, LIMITE_MIN
		BR.N MOVIMENTO_IMPOSSIVEL		
		CMP R2, LIMITE_MAX
		BR.P MOVIMENTO_IMPOSSIVEL
		BR MOVIMENTO_POSSIVEL     ;Está dentro dos limites (0 - 100)

MOVIMENTO_IMPOSSIVEL: MOV R3, R0
		RET

MOVIMENTO_POSSIVEL: MOV R3, 1
		RET
				
;Processo de movimentação (Alinea c)
MOVIMENTO: PUSH R5
		PUSH R6
		CALL LEITURA_POSICOES
		CMP R3, R0
		BR.Z FIM_MOVIMENTO
		CMP R2, R1
		BR.Z NAO_MEXE
		BR.P DIREITA 			  ;Caso contrário: ESQUERDA

ESQUERDA: MOV R4, R0			  ;Sentido = esquerda
		SUB R1, R2				  ;Distância = Pos.Atual - Pos.Destino
		BR IMPULSOS

DIREITA: MOV R4, 1				  ;Sentido = Direita
		MOV R5, R1			
		MOV R1, R2
		SUB R1, R5				  ;Distância = Pos.Destino - Pos.Atual
				
IMPULSOS: MOV R6, R1			  ;R1 = distância
		SHLA R1, 4				  ;Distância vezes 16
		SHLA R6, 2				  ;Distância vezes 4
		ADD R1, R6				  ;Distância vezes 20 (16+4)
		MOV R3, R1				  ;Número de impulsos 
		BR FIM_MOVIMENTO
				
NAO_MEXE: MOV R3, R0			  ;Passo igual a 0 IMPULSOS
		MOV R4, R0				  ;Segue para o fim da rotina

FIM_MOVIMENTO: POP R6
		POP R5
		RET	

;Processamento dos diversos destinos (alínea d)			
PROCESSA_DESTINOS: MOV R7, R0	  ;Indice de destino = 0

SEQUENCIA_DESTINOS: CMP R7, 5	  ;Verifica se já tratámos todas as 
								  ;posições absolutas
		BR.Z FIM_SEQ_DESTINOS

		MOV R1, DESTINOS 		  ;Primeiro endereço da constante
		ADD R1, R7				  ;Aponta para o próximo destino
		MOV R2, M[R1]

		MOV M[POSICAO_DESTINO], R2 
		CALL MOVIMENTO
		CALL PROCESSA_MOV

		INC R7
		BR SEQUENCIA_DESTINOS 

FIM_SEQ_DESTINOS: RET 

PROCESSA_MOV: CMP R3, R0		  ;R3 = nº de impulsos R4= sentido
		BR.Z FIM_PROC_MOV 		  ;Sem impulsos, não mexe

		MOV R1, R4
		CALL SET_DIRECAO

EXECUTA_MOV: CMP R3, R0
		BR.Z ATUALIZA_POS_ATUAL

		CALL IMPULSO

DEC_IMPULSOS: DEC R3
		BR EXECUTA_MOV

ATUALIZA_POS_ATUAL: PUSH R1	  ;Pos. atual passa a ser a pos. destino
		MOV R1, M[POSICAO_DESTINO]
		MOV M[POSICAO_ATUAL], R1
		POP R1

FIM_PROC_MOV: RET

;rotinas fornecidas
LE_SENSOR: MOV R1, M[IO_SENSOR]
		AND R1,1
		RET

SET_DIRECAO: MOV M[IO_DIRECAO],R1
		MOV M[_SENTIDO_MOVIMENTO],R1
		RET

IMPULSO: PUSH R1
		MOV R1, M[_SENTIDO_MOVIMENTO]
		AND R1,1
		MOV M[IO_DIRECAO],R1
		OR R1,2
		MOV M[IO_DIRECAO],R1
		CALL DELAY
		AND R1,1
		MOV M[IO_DIRECAO],R1
		CALL DELAY
		POP R1
		RET

DELAY: 	PUSH R7
		MOV R7,0FFFh

CICLO_DELAY: CMP R7,0
		BR.Z FIM_DELAY
		DEC R7
		BR CICLO_DELAY
FIM_DELAY: POP R7
		RET
	 
FIM:    BR FIM 