% Script efa22_1.m
% Gráfico do erro absoluto do volume em função do raio

% Define 100 pontos para r no intervalo [0, 10]
r = linspace(0, 10, 100);

% Calcula o erro absoluto do volume
E_V = (2 * pi * r / 3) .* (0.02 + 0.001 * r);

% Cria e configura o gráfico
figure(1);
plot(r, E_V, 'b-', 'LineWidth', 2);
title('Erro absoluto do volume E_V em função do raio r');
xlabel('r');
ylabel('E_V');
grid on;
legend('E_V(r) = (2\pi r/3)(0.02 + 0.001r)');

