% Script efa22_2.m
% Método do ponto fixo para encontrar r_max

% Função iteradora
f = @(r) 22.5/pi - 0.05*r.^2;

% Valor inicial
r0 = 0.1;
r_old = r0;

% Parâmetros para estimativa de erro
L = 0.6; % máximo de |f'(r)| no intervalo [5,6]
factor = L/(1-L); % fator M = 1.5

% Tolerância para 5 algarismos significativos
tol = 1e-5;

% Inicializações
k = 0;
results = [k, r0, NaN]; % [iteração, r_k, erro absoluto estimado]

fprintf('Iteração\t r_k\t\t Erro Absoluto Estimado\n');
fprintf('%d\t\t %.6f\t\t NaN\n', k, r0);

% Iterações
for k = 1:100
    r_new = f(r_old);
    diff = abs(r_new - r_old);
    error_est = factor * diff;

    % Armazena resultados
    results(k+1, :) = [k, r_new, error_est];

    % Exibe iteração
    fprintf('%d\t\t %.6f\t\t %.6e\n', k, r_new, error_est);

    % Verifica convergência
    if error_est < tol
        break;
    end

    % Prepara próxima iteração
    r_old = r_new;
end

r_max = r_new;
fprintf('\nEstimativa final de r_max: %.6f\n', r_max);

