-- Q2c) Listar person.name e movie.title das pessoas que aparecem
-- em ambos os papéis 'cast' e 'crew' no mesmo filme.
-- Filtro adicional: o título do filme tem de conter a palavra 'wars'.
-- Abordagem:
-- 1) Juntar person e movie para obter o nome da pessoa e o título do filme.
-- 2) Vou considerar apenas registos em que role_type é 'cast' ou 'crew'
--    e o título do filme conter 'wars'.
-- 3) Agrupar por pessoa e filme.
-- 4) No HAVING, garanto que, para cada (pessoa, filme),
--    existem os dois papéis distintos (COUNT(DISTINCT role_type) = 2).
-- 5) Ordeno de forma ascendente por person.name e movie.title.

SELECT
    p.name  AS person_name,
    m.title AS movie_title
FROM
    role  r
    JOIN person p ON r.person_id = p.person_id
    JOIN movie  m ON r.movie_id  = m.movie_id
WHERE
    r.role_type IN ('cast', 'crew')
    AND m.title LIKE '%wars%'
GROUP BY
    p.name,
    m.title
HAVING
    COUNT(DISTINCT r.role_type) = 2
ORDER BY
    p.name ASC,
    m.title ASC;
