-- Q2d) Listar géneros com mais de 100 filmes com status = 'Released'.
-- Abordagem:
-- 1) Juntar genre → movie_genre → movie para ligar géneros a filmes.
-- 2) Filtrar só os filmes com status 'Released'.
-- 3) Agrupar por género.
-- 4) Usar HAVING para ficar apenas com géneros que têm mais de 100 filmes.
-- 5) Ordenar por total_filmes em ordem descendente.

SELECT
    g.name AS genre_name,
    COUNT(*) AS total_filmes
FROM
    genre       g
    JOIN movie_genre mg ON g.genre_id = mg.genre_id
    JOIN movie       m ON mg.movie_id = m.movie_id
WHERE
    m.status = 'Released'
GROUP BY
    g.genre_id,
    g.name
HAVING
    COUNT(*) > 100
ORDER BY
    total_filmes DESC;
