% efb_sor.m
% Script de teste do método SOR (e-fólio B - Computação Numérica)

n = 100;

% Matriz tridiagonal dominante:
% diagonal principal = 4
% diagonais superior/inferior = -1
A = 4*eye(n) - diag(ones(n-1,1),1) - diag(ones(n-1,1),-1);

% Definir b para que a solução exata seja um vetor de uns
x_exata = ones(n,1);
b = A * x_exata;

% Validar dominância diagonal
[is_dom, r] = verif_dominancia(A);
fprintf('Matriz dominante (1=sim, 0=nao): %d\n', is_dom);

% (Opcional) Mostrar o pior rácio (linha mais "problemática")
fprintf('Maior rácio r (pior linha): %.6f\n', max(r));

% Parâmetros do método
x0 = zeros(n,1);
tol = 1e-6;
max_iter = 5000;

% Valores de omega a testar
omegas = [1.0, 1.25, 1.8];

fprintf('\nResultados SOR:\n');
fprintf('-----------------------------------------------\n');

for k = 1:length(omegas)
    omega = omegas(k);

    tic;
    [x, iter] = solve_sor(A, b, omega, x0, tol, max_iter);
    tempo = toc;

    erro = norm(x - x_exata, inf);

    fprintf('omega = %.2f | iter = %4d | tempo = %.6f s | erro_inf = %.2e\n', ...
            omega, iter, tempo, erro);
end
