function [x, iter] = solve_sor(A, b, omega, x0, tol, max_iter)
% Resolve Ax=b pelo método SOR
% omega: fator de relaxamento
% x0: aproximação inicial
% tol: tolerância (norma infinito)
% max_iter: máximo de iterações

n = length(b);
x = x0;

for iter = 1:max_iter
    x_old = x;

    for i = 1:n
        if i > 1
            soma1 = A(i,1:i-1) * x(1:i-1);
        else
            soma1 = 0;
        end

        if i < n
            soma2 = A(i,i+1:n) * x_old(i+1:n);
        else
            soma2 = 0;
        end

        x(i) = (1 - omega)*x_old(i) + ...
               (omega / A(i,i)) * (b(i) - soma1 - soma2);
    end

    if norm(x - x_old, inf) < tol
        return;
    end
end

warning('Número máximo de iterações excedido.');
end
