function [is_dom, r] = verif_dominancia(A)
% Verifica se a matriz A é estritamente dominante diagonalmente por linhas
% A: matriz quadrada
% is_dom: true se for dominante, false caso contrário
% r: vetor com o rácio (soma extra-diagonal / diagonal) por linha

diagA = abs(diag(A));
soma_extra = sum(abs(A), 2) - diagA;

r = soma_extra ./ diagA;
is_dom = all(diagA > soma_extra);

end
