﻿/*
** file: Instancias.cs
**
** IAResgate
** UC: 21071 - IIA @ UAb
** e-fólio A 2024-25
**
** Aluno: 2300163 - Luis Pereira
*/


namespace IAResgate
{
    // Representa uma instância do problema
    public class Instancia
    {
        public int[,] Mapa { get; }       // Mapa da instância
        public int N { get; }             // Dimensão do mapa (NxN)
        public int K { get; }             // Número de visitantes a resgatar
        public int W { get; }             // Número total de visitantes no mapa
        public int Tempo { get; }         // Tempo inicial disponível

        public Instancia(int[,] mapa, int n, int k, int w, int tempo)
        {
            Mapa = mapa;
            N = n;
            K = k;
            W = w;
            Tempo = tempo;
        }
    }

    // Conjunto de todas as instâncias fornecidas
    public static class Instancias
    {
        public static readonly Instancia[] Todas = new Instancia[]
        {
            // Instância 1
            new Instancia(new int[,]
            {
                {1,1,1,1,-1},
                {1,10,1,2,10},
                {1,-2,10,2,1},
                {10,10,1,1,1},
                {-1,1,1,2,-2}
            }, 5, 2, 4, 10),

            // Instância 2
            new Instancia(new int[,]
            {
                {-1,1,2,2,-1},
                {1,2,1,1,10},
                {1,1,10,2,2},
                {10,2,1,10,1},
                {-1,2,1,10,-2}
            }, 5, 3, 4, 20),

            // Instância 3
            new Instancia(new int[,]
            {
                {1,1,1,1,10,-2,1},
                {1,-2,10,1,1,10,1},
                {1,10,1,10,1,1,1},
                {1,1,-2,10,1,2,1},
                {2,1,10,1,2,1,10},
                {2,1,1,1,2,10,-3},
                {1,-1,10,1,1,1,1}
            }, 7, 3, 5, 15),

            // Instância 4
            new Instancia(new int[,]
            {
                {1,-2,2,2,2,-2,1},
                {1,1,1,1,1,1,1},
                {1,10,10,10,10,10,1},
                {1,1,-2,10,1,2,1},
                {2,2,2,10,2,10,10},
                {2,1,2,10,2,10,-3},
                {1,-1,2,1,1,1,1}
            }, 7, 4, 5, 20),

            // Instância 5
            new Instancia(new int[,]
            {
                {-2,10,1,1,1,1,-2,1,1},
                {1,2,-2,10,10,1,1,10,2},
                {1,1,1,1,1,10,10,1,1},
                {1,10,10,1,10,-2,1,1,1},
                {1,1,10,1,1,1,2,10,1},
                {2,1,1,10,1,2,10,1,1},
                {10,10,2,2,2,2,10,-3,1},
                {2,1,1,10,1,2,10,1,10},
                {-8,10,1,1,1,1,1,1,1}
            }, 9, 4, 6, 19),

            // Instância 6
            new Instancia(new int[,]
            {
                {1,-5,1,10,1,1,1,1,1,1,1},
                {1,1,10,1,2,1,10,1,1,1,1},
                {1,10,10,1,1,1,1,10,1,-3,1},
                {1,2,-1,10,2,2,1,2,10,1,1},
                {2,1,1,1,10,2,1,1,2,10,1},
                {1,2,1,1,1,10,-2,1,2,10,1},
                {2,1,2,10,1,1,10,1,1,10,1},
                {1,-1,1,10,1,2,1,1,10,2,1},
                {1,10,10,10,1,2,-1,10,2,2,1},
                {1,1,1,1,1,2,10,1,1,1,-4},
                {1,1,-2,2,1,1,1,2,2,2,1}
            }, 11, 6, 8, 48),

            // Instância 7
            new Instancia(new int[,]
            {
                {1,1,1,1,1,10,1,2,1,1,1,1,1},
                {-1,10,1,10,1,2,10,1,10,2,10,10,1},
                {10,1,1,10,1,2,10,2,10,1,10,-1,1},
                {1,1,10,1,1,1,-1,1,10,-1,1,10,10},
                {1,10,1,1,1,10,1,1,10,10,1,1,1},
                {1,10,-1,10,1,1,10,1,1,1,10,10,1},
                {1,10,1,1,10,1,1,10,10,1,1,10,1},
                {10,10,10,-1,1,10,1,1,10,1,1,10,1},
                {1,2,1,10,2,1,10,1,10,-1,10,1,1},
                {1,10,2,1,10,2,10,1,10,1,10,1,1},
                {1,-1,10,1,2,1,10,1,10,1,1,1,10},
                {1,10,1,10,10,10,10,1,10,1,10,10,-1},
                {1,1,1,-1,1,1,1,1,10,1,1,1,1}
            }, 13, 10, 10, 120),

            // Instância 8
            new Instancia(new int[,]
            {
                {-3,1,1,1,1,1,1,1,2,2,2,1,-3,1,-2},
                {1,1,1,1,1,10,10,10,10,10,1,1,2,1,2},
                {1,1,1,1,1,2,1,1,1,1,1,1,1,1,-2},
                {1,1,1,1,1,1,-2,2,1,-3,1,1,1,1,1},
                {1,1,1,1,1,1,1,2,1,2,1,1,1,1,1},
                {1,10,1,1,1,2,2,1,2,1,1,1,-1,10,1},
                {1,10,-3,1,2,1,1,2,1,1,1,1,1,10,1},
                {1,10,1,1,-2,2,1,1,1,1,2,2,1,10,1},
                {1,10,1,1,1,1,2,1,1,1,1,1,1,10,2},
                {1,10,-2,2,1,2,1,2,1,1,1,1,1,10,1},
                {1,1,1,1,1,1,1,1,1,1,2,1,1,1,2},
                {-2,1,1,2,1,2,1,1,1,2,1,2,1,-3,1},
                {1,1,1,1,2,1,1,1,1,1,1,1,1,1,1},
                {1,2,1,1,1,10,10,10,10,10,1,1,2,1,1},
                {1,1,-3,1,1,1,1,1,1,1,1,-3,1,1,-4}
            }, 15, 10, 15, 30),

            // Instância 9
            new Instancia(new int[,]
            {
                {-3,1,1,1,1,1,1,1,2,2,2,1,-3,1,-2},
                {1,1,1,1,1,10,10,10,10,10,1,1,2,1,2},
                {1,1,1,1,1,2,1,10,1,1,1,1,1,1,-2},
                {1,1,1,1,1,1,-2,10,1,-3,1,1,1,1,1},
                {1,10,10,10,1,10,1,10,1,10,1,10,10,10,1},
                {1,10,1,1,1,10,2,10,2,10,1,1,-1,10,1},
                {1,10,-3,1,2,10,1,1,1,10,1,1,1,10,1},
                {1,10,1,1,-2,10,10,10,10,10,2,2,1,10,1},
                {1,10,1,1,1,10,2,1,1,10,1,1,1,10,2},
                {1,10,-2,2,1,10,1,10,1,10,1,1,1,10,1},
                {1,10,10,10,1,10,1,10,1,10,2,10,10,10,2},
                {-2,1,1,2,1,2,1,10,1,2,1,2,1,-3,1},
                {1,1,1,1,2,1,1,10,1,1,1,1,1,1,1},
                {1,2,1,1,1,10,10,10,10,10,1,1,2,1,1},
                {1,1,-3,1,1,1,1,1,1,1,1,-3,1,1,-4}
            }, 15, 10, 15, 45),

            // Instância 10
            new Instancia(new int[,]
            {
                {-6,10,1,1,1,1,1,1,2,2,2,10,-6,1,-4},
                {1,10,1,10,1,10,10,10,10,10,1,1,2,10,2},
                {1,10,1,10,1,2,1,10,1,10,1,10,1,10,-4},
                {1,1,1,10,1,10,-4,10,1,-6,1,10,1,1,1},
                {1,10,10,10,1,10,1,10,1,10,1,10,10,10,1},
                {1,10,1,1,1,10,2,10,2,10,1,10,-2,10,1},
                {1,10,-6,10,2,10,1,1,1,10,1,10,1,10,1},
                {1,10,1,10,-4,10,10,10,10,10,2,2,1,10,1},
                {1,10,1,10,10,10,2,1,1,10,10,10,1,10,2},
                {1,10,-4,2,1,1,1,10,1,10,1,1,1,10,1},
                {1,10,10,10,1,10,1,10,1,10,2,10,10,10,2},
                {-4,1,1,2,1,10,1,10,1,2,1,2,1,-6,1},
                {10,10,1,10,2,10,1,10,1,10,1,10,10,10,10},
                {1,10,1,10,1,10,10,10,10,10,1,10,2,10,1},
                {1,1,-6,10,1,1,1,1,1,1,1,-6,1,1,-8}
            }, 15, 15, 15, 45)
        };
    }
}