/*
** file: main.cs
**
** IAResgate
** UC: 21071 - IIA @ UAb
** e-fólio A 2024-25
**
** Aluno: 2300163 - Luis Pereira
*/

using System.Diagnostics;
using IAResgate;

class Program
{
    // Lista de resultados para UCS, DFS e BFS (instância, algoritmo, custo, tempo, expansões, gerações, tempo em segundos)
    static List<(string algoritmo, int instancia, int custo, int tempo, int expansoes, int geracoes, double tempoSegundos)> resultados = new();

    static void Main()
    {
        for (int i = 0; i < Instancias.Todas.Length; i++)
        {
            var instancia = Instancias.Todas[i];
            Console.Clear();
            Console.WriteLine($"Instância {i + 1} - Mapa Inicial:");
            ImprimirMapaFormatado(instancia.Mapa, new List<(int, int)>(), (-1, -1), new HashSet<(int, int)>(), (-1, -1), (-1, -1), mostrarTodasPortas: true);
            Console.WriteLine($"Parâmetros: N={instancia.N}, K={instancia.K}, W={instancia.W}, Tempo={instancia.Tempo}\n");
            Console.ReadLine();

            // Algoritmo UCS (Uniform Cost Search)
            int expUCS = 0, genUCS = 0;
            var swUCS = Stopwatch.StartNew();
            ResultadoUCS? resultadoTempUCS = null;
            bool sucessoUCS = Task.Run(() =>
            {
                return Algoritmos.UCS(instancia, out resultadoTempUCS, ref expUCS, ref genUCS);
            }).Wait(TimeSpan.FromSeconds(500));
            swUCS.Stop();

            if (sucessoUCS && resultadoTempUCS != null)
            {
                var resultadoUCS = resultadoTempUCS;
                Console.WriteLine("Resultado UCS:");
                ApresentarPorPartes(instancia, resultadoUCS);
                resultados.Add(("UCS", i + 1, resultadoUCS.CustoTotal, resultadoUCS.TempoRestante, expUCS, genUCS, swUCS.Elapsed.TotalSeconds));
            }
            else
            {
                Console.WriteLine("Não foi possível encontrar um caminho válido com algoritmo UCS (timeout ou falha).");
                resultados.Add(("UCS", i + 1, -1, -1, expUCS, genUCS, swUCS.Elapsed.TotalSeconds));
            }

            Console.WriteLine("\nPressione Enter para continuar para DFS...");
            Console.ReadLine();

            // Algoritmo DFS (Depth-First Search)
            int expDFS = 0, genDFS = 0;
            var swDFS = Stopwatch.StartNew();
            ResultadoDFS? resultadoTempDFS = null;
            bool sucessoDFS = Task.Run(() =>
            {
                return Algoritmos.DFS(instancia, out resultadoTempDFS, ref expDFS, ref genDFS);
            }).Wait(TimeSpan.FromSeconds(500));
            swDFS.Stop();

            if (sucessoDFS && resultadoTempDFS != null)
            {
                var resultadoDFS = resultadoTempDFS;
                Console.WriteLine("Resultado DFS:");
                ApresentarPorPartes(instancia, (ResultadoUCS)resultadoDFS);
                resultados.Add(("DFS", i + 1, resultadoDFS.CustoTotal, resultadoDFS.TempoRestante, expDFS, genDFS, swDFS.Elapsed.TotalSeconds));
            }
            else
            {
                Console.WriteLine("Não foi possível encontrar um caminho válido com algoritmo DFS (timeout ou falha).");
                resultados.Add(("DFS", i + 1, -1, -1, expDFS, genDFS, swDFS.Elapsed.TotalSeconds));
            }

            Console.WriteLine("\nPressione Enter para continuar para BFS...");
            Console.ReadLine();

            // Algoritmo BFS (Breadth-First Search)
            int expBFS = 0, genBFS = 0;
            var swBFS = Stopwatch.StartNew();
            ResultadoBFS? resultadoTempBFS = null;
            bool sucessoBFS = Task.Run(() =>
            {
                return Algoritmos.BFS(instancia, out resultadoTempBFS, ref expBFS, ref genBFS);
            }).Wait(TimeSpan.FromSeconds(500));
            swBFS.Stop();

            if (sucessoBFS && resultadoTempBFS != null)
            {
                var resultadoBFS = resultadoTempBFS;
                Console.WriteLine("Resultado BFS:");
                ApresentarPorPartes(instancia, (ResultadoUCS)resultadoBFS);
                resultados.Add(("BFS", i + 1, resultadoBFS.CustoTotal, resultadoBFS.TempoRestante, expBFS, genBFS, swBFS.Elapsed.TotalSeconds));
            }
            else
            {
                Console.WriteLine("Não foi possível encontrar um caminho válido com algoritmo BFS (timeout ou falha).");
                resultados.Add(("BFS", i + 1, -1, -1, expBFS, genBFS, swBFS.Elapsed.TotalSeconds));
            }

            Console.WriteLine("\nPressione Enter para continuar para a próxima instância...");
            Console.ReadLine();
        }

        ApresentarTabelaFinal();
    }

    // Mostra o caminho passo a passo, atualizando o mapa a cada resgate
    static void ApresentarPorPartes(Instancia instancia, ResultadoUCS resultado)
    {
        var mapa = instancia.Mapa;
        var caminho = resultado.Caminho;
        var caminhoAteAgora = new List<(int, int)>();
        var visitados = new HashSet<(int, int)>();
        int resgatados = 0;
        int parte = 1;
        int tempo = instancia.Tempo;
        int custoTotal = 0;
        int passosUltimaParte = 0;
        (int, int) entrada = caminho.First();
        (int, int) saida = caminho.Last();

        for (int i = 0; i < caminho.Count; i++)
        {
            var pos = caminho[i];
            caminhoAteAgora.Add(pos);
            passosUltimaParte++;

            int valor = mapa[pos.Item1, pos.Item2];
            int custoMov = valor > 0 ? valor : 1;
            tempo -= custoMov;
            custoTotal += custoMov;

            if (valor < 0 && !visitados.Contains(pos))
            {
                tempo += Math.Abs(valor);
                resgatados++;
                visitados.Add(pos);

                if (resgatados < instancia.K)
                {
                    Console.Clear();
                    Console.WriteLine($"\nParte {parte}, passos {passosUltimaParte}:");
                    ImprimirMapaFormatado(mapa, caminhoAteAgora, pos, visitados, entrada, (-1, -1), mostrarTodasPortas: false);
                    Console.WriteLine($"Tempo: {tempo} ({resgatados}/{instancia.K}), custo {custoTotal}\n");
                    Console.ReadKey();
                    parte++;
                    passosUltimaParte = 0;
                }
            }
        }

        Console.Clear();
        Console.WriteLine($"\nParte {parte}, passos {passosUltimaParte + 1}:");
        ImprimirMapaFormatado(mapa, caminhoAteAgora, (-1, -1), visitados, entrada, saida, mostrarTodasPortas: false);
        Console.WriteLine($"Tempo: {resultado.TempoRestante} ({resultado.VisitantesResgatados}/{instancia.K}), custo: {resultado.CustoTotal}");
    }

    // Mostra a tabela final de resultados e os totais por algoritmo
    static void ApresentarTabelaFinal()
    {
        Console.Clear();
        Console.WriteLine("\nTabela de resultados, da execução dos algoritmos nas instâncias do eFolioA:");
        Console.WriteLine("Instância | Algoritmo | Custo(g) | Expansões | Gerações | Tempo(s)");
        Console.WriteLine(new string('-', 70));

        foreach (var grupo in resultados.GroupBy(r => r.instancia))
        {
            foreach (var (algoritmo, instancia, custo, tempo, expansoes, geracoes, segundos) in grupo)
            {
                string custoStr = custo == -1 ? "---" : custo.ToString();
                Console.WriteLine($"   {instancia,2}     | {algoritmo,-9} | {custoStr,7} | {expansoes,9} | {geracoes,8} | {segundos,7:F3}");
            }
            Console.WriteLine();
        }

        Console.WriteLine(new string('-', 70));

        foreach (var alg in new[] { "UCS", "DFS", "BFS" })
        {
            var filtro = resultados.Where(r => r.algoritmo == alg && r.custo != -1);
            int somaCusto = filtro.Sum(r => r.custo);
            int somaExp = filtro.Sum(r => r.expansoes);
            int somaGer = filtro.Sum(r => r.geracoes);
            double somaTempo = filtro.Sum(r => r.tempoSegundos);

            Console.WriteLine($"Total {alg,-4} |          | {somaCusto,7} | {somaExp,9} | {somaGer,8} | {somaTempo,7:F3}");
        }
    }

    // Mostra o mapa formatado, destacando caminho, atual, resgatados, entrada e saída
    static void ImprimirMapaFormatado(
        int[,] mapa,
        List<(int, int)> caminho,
        (int, int) atual,
        HashSet<(int, int)> resgatados,
        (int, int) entrada,
        (int, int) saida,
        bool mostrarTodasPortas)
    {
        int n = mapa.GetLength(0);
        int meio = n / 2;
        int larguraCelula = 4;
        int larguraMapa = n * larguraCelula;

        string cima = mostrarTodasPortas || entrada == (0, meio) || saida == (0, meio) ? "|v|" : "   ";
        string baixo = mostrarTodasPortas || entrada == (n - 1, meio) || saida == (n - 1, meio) ? "|^|" : "   ";

        string barraCima = "*" + new string('-', larguraMapa / 2 - 1) + cima + new string('-', larguraMapa / 2 - 1) + "*";
        string barraBaixo = "*" + new string('-', larguraMapa / 2 - 1) + baixo + new string('-', larguraMapa / 2 - 1) + "*";

        Console.WriteLine(barraCima);

        for (int i = 0; i < n; i++)
        {
            string linha = i == meio && (mostrarTodasPortas || entrada == (meio, 0) || saida == (meio, 0)) ? "> " : (i == meio ? "  " : "| ");

            for (int j = 0; j < n; j++)
            {
                var pos = (i, j);
                string s;
                int val = mapa[i, j];

                if (pos == atual && resgatados.Contains(pos)) s = "[+]";
                else if (resgatados.Contains(pos)) s = "(+)";
                else if (pos == atual) s = "[x]";
                else if (caminho.Contains(pos)) s = val == 2 ? "(:)" : "(.)";
                else s = val switch
                {
                    10 => "#",
                    2 => ":",
                    1 => ".",
                    < 0 => Math.Abs(val).ToString(),
                    _ => "."
                };

                linha += s.PadRight(larguraCelula);
            }

            linha += i == meio && (mostrarTodasPortas || entrada == (meio, n - 1) || saida == (meio, n - 1)) ? "<" : (i == meio ? " " : "|");
            Console.WriteLine(linha);
        }

        Console.WriteLine(barraBaixo);
    }
}