/*
** file: main.cs
**
** IAResgateB
** UC: 21071 - IIA @ UAb
** e-fólio B 2024-25
**
** Aluno: 2300163 - Luis Pereira
*/

using System.Diagnostics;
using IAResgateB;

class Program
{
    static void Main()
    {
        // Guarda o custo final de cada instância
        int[] custos = new int[10];
        // Guarda o tempo de execução (em segundos) de cada instância
        double[] tempos = new double[10];
        // Guarda o número de expansões feitas em cada instância
        int[] exp = new int[10];
        // Guarda o número de gerações feitas em cada instância
        int[] ger = new int[10];
        // Guarda o número de avaliações feitas em cada instância
        int[] aval = new int[10];
        // Itera sobre todas as instâncias definidas
        for (int i = 0; i < Instancias.Todas.Length; i++)
        {
            // Obtém a instância atual
            var instancia = Instancias.Todas[i];
            // Limpa o ecrã do terminal para apresentação limpa
            Console.Clear();
            // Identifica a instância atual
            Console.WriteLine($"Instância {i + 1} - Mapa Inicial:");
            // Mostra o mapa inicial com todas as portas visíveis
            ImprimirMapaFormatado(instancia.Mapa, new(), (-1, -1), new(), (-1, -1), (-1, -1), true, true);
            // Mostra os parâmetros da instância
            Console.WriteLine($"Parâmetros: N={instancia.N}, K={instancia.K}, W={instancia.W}, Tempo={instancia.Tempo}");
            Console.WriteLine("\nPressione Enter para iniciar o algoritmo na instância...");
            // Espera o utilizador carregar Enter
            Console.ReadLine();
            
            // Inicia cronómetro para medir o tempo de execução
            var sw = Stopwatch.StartNew();
            // Executa o algoritmo de procura na instância
            var resultado = Algoritmos.PasseioSatisfacao(instancia);
            // Para o cronómetro
            sw.Stop();
            
            // Guarda o tempo de execução (em segundos) para esta instância
            tempos[i] = sw.Elapsed.TotalSeconds;
            // Guarda o número total de expansões realizadas na procura
            exp[i] = Algoritmos.Expansoes;
            // Guarda o número total de gerações (novos nós criados)
            ger[i] = Algoritmos.Geracoes;
            // Guarda o número total de avaliações (nós analisados do topo da fila)
            aval[i] = Algoritmos.Avaliacoes;
            
            if (resultado != null)
            {
                // Extrai o caminho encontrado pelo algoritmo
                var (caminho, _) = resultado.Value;
                // Incrementa satisfação de saída
                int satisfacao = CalcularSatisfacao(instancia, caminho) + 1; 

                //Debug Caminho que o algoritmo retorna
                /*Console.WriteLine("\nDEBUG - Caminho devolvido pelo algoritmo:");
                foreach (var (x, y) in caminho)
                {
                    Console.Write($"({x},{y}) ");
                }
                Console.WriteLine();*/

                Console.WriteLine("Resultado - Melhor passeio de satisfação:");
                // Trocar linha, para ver passo a passo. Apresentar por partes. (Ativar bloco também)
                //int tempoGasto = ApresentarPorPartes(instancia, caminho);
                int tempoGasto = ApresentarSoFinal(instancia, caminho);
                
                // Calcula o custo final com base no tempo e satisfação obtida
                int custo = instancia.Tempo + instancia.K - satisfacao;
                //Guarda o custo da instancia atual
                custos[i] = custo;
                
                // Exibe tempo efetivamente usado
                Console.WriteLine($"\n• Tempo gasto: {tempoGasto}/{instancia.Tempo} minutos");
                // Exibe tempo efetivamente usado
                Console.WriteLine($"• Satisfação obtida: {satisfacao}");
                // Mostra custo calculado (Tempo+K-Satisfação)
                Console.WriteLine($"• Custo resultante: {custo}");
                // Tempo de execução do algoritm
                Console.WriteLine($"• Duração: {sw.Elapsed.TotalSeconds:F2}s");
            }
            else
            {
                // Marca como sem solução encontrada
                custos[i] = -1;
                Console.WriteLine("Não foi encontrado nenhum passeio válido dentro do tempo limite.");
            }

            Console.WriteLine("\nPressione Enter para continuar para a próxima instância...");
            // Espera o utilizador carregar Enter
            Console.ReadLine();
        }
        
        
        Console.Clear(); 
        // Cabeçalho da secção de resultados
        Console.WriteLine("\nTabela de Resultados:"); 
        Console.WriteLine("Instância | Custo(g) | Expansões | Gerações | Avaliações | Tempo(s)");
        Console.WriteLine("---------------------------------------------------------------");

        // Inicializa acumuladores para totais
        int totalCusto = 0, totalExp = 0, totalGer = 0, totalAval = 0;
        double totalTempo = 0;

        // Percorre os resultados de cada instância
        for (int i = 0; i < 10; i++)
        {
            // Mostra "--" se não houve solução
            string custoStr = custos[i] == -1 ? "--" : custos[i].ToString(); 
            Console.WriteLine($"{i + 1,9} | {custoStr,8} | {exp[i],9} | {ger[i],9} | {aval[i],11} | {tempos[i],8:F2}");

            // Soma para os totais, exceto custo inválido
            if (custos[i] != -1) totalCusto += custos[i];
            totalExp += exp[i];
            totalGer += ger[i];
            totalAval += aval[i];
            totalTempo += tempos[i];
        }

        Console.WriteLine("---------------------------------------------------------------");
        // Imprime totais agregados
        Console.WriteLine($"Total     | {totalCusto,8} | {totalExp,9} | {totalGer,9} | {totalAval,11} | {totalTempo,8:F2}");

    }

    // Calcula a satisfação total de um caminho
    static int CalcularSatisfacao(Instancia instancia, List<(int, int)> caminho)
    {
        int[,] mapa = instancia.Mapa;
        // Casas já visitadas
        var visitados = new HashSet<(int, int)>(); 
        // Total de pontos
        int satisfacao = 0; 
        // Penalização por repetição
        int penalizacao = 0; 

        foreach (var pos in caminho)
        {
            // Primeira visita à casa
            if (!visitados.Contains(pos)) 
            {
                // Ganha 1 ponto base
                satisfacao += 1; 
                if (mapa[pos.Item1, pos.Item2] < 0)
                    // Soma pontos se for POI
                    satisfacao += Math.Abs(mapa[pos.Item1, pos.Item2]); 
                // Reseta penalização
                penalizacao = 0; 
            }
            // Repetição de casa
            else 
            {
                penalizacao++;
                if (penalizacao >= 2)
                    // Penaliza se visitar +2 seguidas
                    satisfacao -= 1; 
            }
            visitados.Add(pos);
        }

        return satisfacao;
    }
    
    /*
    // Ativar retirando (/*) para apresentar por partes (ativar chamada também)
    // Apresenta o caminho passo a passo com pausa entre movimentos
    static int ApresentarPorPartes(Instancia instancia, List<(int, int)> caminho)
    {
        var mapa = instancia.Mapa;
        // Caminho acumulado
        var caminhoAteAgora = new List<(int, int)>(); 
        // Casas já mostradas
        var visitados = new HashSet<(int, int)>();    
        int tempo = instancia.Tempo;
        int parte = 1;
        (int, int) entrada = caminho.First();
        (int, int) saida = caminho.Last();

        // Mostra cada passo do caminho
        for (int i = 0; i < caminho.Count; i++)
        {
            var pos = caminho[i];
            int val = mapa[pos.Item1, pos.Item2];

            // Define custo da casa
            int custoMov = (val == 2) ? 2 : 1;
            if (val < 0) custoMov = 1;

            tempo -= custoMov;
            caminhoAteAgora.Add(pos);

            Console.Clear();
            Console.WriteLine($"Parte {parte}: Passo em ({pos.Item1},{pos.Item2}), Tempo restante: {tempo}");
            ImprimirMapaFormatado(mapa, caminhoAteAgora, pos, visitados, entrada, (-1, -1), false, false);
            visitados.Add(pos);
            // Espera o utilizador carregar Enter
            Console.ReadKey(); 
            parte++;
        }
                
        // Último passo: saída
        tempo -= 1;
        Console.Clear();
        Console.WriteLine($"Parte {parte}: Passo final (saída) a partir de ({saida.Item1},{saida.Item2}), Tempo restante: {tempo}");
        ImprimirMapaFormatado(mapa, caminhoAteAgora, (-1, -1), visitados, entrada, saida, true, false);
        Console.ReadKey();

        return instancia.Tempo - tempo;
    }
    */
    
    //Ocultar com (/*) caso ative o ApresentarPorPartes
    // Apresenta apenas o estado final do caminho percorrido
    static int ApresentarSoFinal(Instancia instancia, List<(int, int)> caminho)
    {
        var mapa = instancia.Mapa;
        // Cópia do caminho
        var caminhoAteAgora = new List<(int, int)>(caminho); 
        // Casas visitadas
        var visitados = new HashSet<(int, int)>(caminho);    
        int tempo = instancia.Tempo;
        (int, int) entrada = caminho.First();
        (int, int) saida = caminho.Last();

        // Subtrai o tempo total gasto no percurso
        foreach (var pos in caminho)
        {
            int val = mapa[pos.Item1, pos.Item2];
            int custoMov = (val == 2) ? 2 : 1;
            if (val < 0) custoMov = 1;
            tempo -= custoMov;
        }

        // Último minuto é gasto na saída
        tempo -= 1; 
        Console.Clear();
        Console.WriteLine($"Parte final com (saída) e Tempo restante: {tempo}");
        // Mostra o mapa com as portas usadas visíveis
        ImprimirMapaFormatado(mapa, caminhoAteAgora, (-1, -1), visitados, entrada, saida, true, false);

        return instancia.Tempo - tempo;
    }
    // Imprime o mapa formatado com o caminho, entrada, saída e casas visitadas
static void ImprimirMapaFormatado(
    int[,] mapa,
    // Caminho percorrido
    List<(int, int)> caminho,          
    // Posição atual
    (int, int) atual,                  
    // Casas já visitadas
    HashSet<(int, int)> visitados,    
    // Porta de entrada
    (int, int) entrada,               
    // Porta de saída
    (int, int) saida,                 
    // Se deve mostrar a saída
    bool mostrarSaida,                
    // Se mostra todas as portas
    bool mostrarTodasPortas)         
{
    int n = mapa.GetLength(0);
    int meio = n / 2;
    int larguraCelula = 4;
    int larguraMapa = n * larguraCelula;

    // Decide se mostra portas em cima/baixo
    bool mostrarCima = mostrarTodasPortas || entrada == (0, meio) || (mostrarSaida && saida == (0, meio));
    bool mostrarBaixo = mostrarTodasPortas || entrada == (n - 1, meio) || (mostrarSaida && saida == (n - 1, meio));

    // Imprime bordas superior e inferior com indicação de porta
    string barraCima = "*" + new string('-', larguraMapa / 2 - 1) + (mostrarCima ? "|v|" : "   ") + new string('-', larguraMapa / 2 - 1) + "*";
    string barraBaixo = "*" + new string('-', larguraMapa / 2 - 1) + (mostrarBaixo ? "|^|" : "   ") + new string('-', larguraMapa / 2 - 1) + "*";

    Console.WriteLine(barraCima);

    for (int i = 0; i < n; i++)
    {
        // Decide se mostra portas à esquerda/direita
        bool mostrarEsquerda = mostrarTodasPortas || entrada == (meio, 0) || (mostrarSaida && saida == (meio, 0));
        bool mostrarDireita = mostrarTodasPortas || entrada == (meio, n - 1) || (mostrarSaida && saida == (meio, n - 1));

        string linha = i == meio && mostrarEsquerda ? "> " : (i == meio ? "  " : "| ");

        for (int j = 0; j < n; j++)
        {
            var pos = (i, j);

            // Define o caractere base conforme o tipo de casa
            string baseChar = mapa[i, j] switch
            {
                // Parede
                10 => "#",                  
                // Casa lenta
                2 => ":",                   
                // Caminho normal
                1 => ".",                   
                // POI (negativo)
                < 0 => Math.Abs(mapa[i, j]).ToString(), 
                _ => "."
            };

            string s;
            // Casa atual já visitada
            if (pos == atual && visitados.Contains(pos)) s = "{x}";
            // Casa atual ainda não visitada
            else if (pos == atual) s = "[x]";
            // Casa foi visitada mais do que uma vez
            else if (visitados.Contains(pos) && caminho.Count(p => p == pos) > 1)
                s = baseChar switch
                {
                    "." => "{.}",
                    ":" => "{:}",
                    var ch when int.TryParse(ch, out _) => "{+}",
                    _ => "{ }"
                };
            // Casa visitada uma vez
            else if (visitados.Contains(pos))
                s = baseChar switch
                {
                    "." => "(.)",
                    ":" => "(:)",
                    var ch when int.TryParse(ch, out _) => "(+)",
                    _ => "(.)"
                };
            // Fallback casa aparece no caminho final, mas não foi marcada como visitada
            else if (caminho.Contains(pos))
                s = baseChar switch
                {
                    "." => "(.)",
                    ":" => "(:)",
                    var ch when int.TryParse(ch, out _) => "(+)",
                    _ => "(.)"
                };
            else s = baseChar;

            linha += s.PadRight(larguraCelula);
        }

        linha += i == meio && mostrarDireita ? "<" : (i == meio ? " " : "|");
        Console.WriteLine(linha);
    }

    Console.WriteLine(barraBaixo);
}
}