from player import Player
from utils import limpar_ecra
import json
import os

from utils import limpar_ecra


class Classificacoes:
    def __init__(self):
        self.file = "classificacoes.json"  # Caminho do ficheiro onde as classificações são guardadas
        self.classificacoes = self.carregar_classificacoes()  # Carrega as classificações ao iniciar

    def carregar_classificacoes(self):
        if os.path.exists(self.file):  # Verifica se o ficheiro existe
            with open(self.file, "r") as f:
                return json.load(f)  # Carrega as classificações do ficheiro
        return {}  # Retorna um dicionário vazio se não houver classificações

    def guardar_classificacoes(self):
        with open(self.file, "w") as f:
            json.dump(self.classificacoes, f, indent=4)  # Guarda as classificações no ficheiro

    def atualizar_classificacoes(self, nome_jogador, venceu):
        if nome_jogador not in self.classificacoes:  # Verifica se o jogador já existe nas classificações
            self.classificacoes[nome_jogador] = {
                "maos_jogadas": 0,  # Inicializa as estatísticas do jogador
                "maos_ganhas": 0,
                "percentagem_vitoria": 0.0
            }

        self.classificacoes[nome_jogador]["maos_jogadas"] += 1  # Incrementa o número de mãos jogadas
        if venceu:
            self.classificacoes[nome_jogador]["maos_ganhas"] += 1  # Incrementa as mãos ganhas se o jogador venceu

        total_jogadas = self.classificacoes[nome_jogador]["maos_jogadas"]  # Total de mãos jogadas
        total_ganhas = self.classificacoes[nome_jogador]["maos_ganhas"]  # Total de mãos ganhas
        self.classificacoes[nome_jogador]["percentagem_vitoria"] = round((total_ganhas / total_jogadas) * 100, 2)  # Calcula a percentagem de vitórias
        self.guardar_classificacoes()  # Guarda as classificações atualizadas

    def calcular_percentagem_media(self):
        total_vitoria = sum(stats["percentagem_vitoria"] for stats in self.classificacoes.values())
        total_jogadores = len(self.classificacoes)
        return round(total_vitoria / total_jogadores, 2) if total_jogadores > 0 else 0.0

    def mostrar_classificacoes(self):
        limpar_ecra()
        if not self.classificacoes:  # Verifica se há classificações
            print("Ainda não há classificações.")
        else:
            # Converte as classificações em objetos Player
            jogadores = []
            for nome, stats in self.classificacoes.items():
                jogador = Player(nome)
                jogador.victory_percentage = stats["percentagem_vitoria"]
                jogadores.append(jogador)

            # Ordena os jogadores usando a sobrecarga de operadores (decrescente)
            top10 = sorted(jogadores, key=lambda x: x.victory_percentage, reverse=True)[:10]

            # Exibe o Top 10 com mãos jogadas, ganhas e percentagem de vitórias
            print("===== TOP 10 - Estatísticas =====")
            for i, jogador in enumerate(top10, start=1):
                stats = self.classificacoes[jogador.name]
                print(f"{i}. {jogador.name}: {stats['maos_jogadas']} mãos jogadas, "
                      f"{stats['maos_ganhas']} mãos ganhas, {jogador.victory_percentage}% vitórias")

            # Calcula a percentagem média de vitórias dos jogadores
            media_vitoria = self.calcular_percentagem_media()

            # Exibe o Top 10 com a comparação vs a média
            print("\n===== TOP 10 - Comparação com a Média =====")
            for i, jogador in enumerate(top10, start=1):
                stats = self.classificacoes[jogador.name]
                comparacao = "está acima" if jogador.victory_percentage > media_vitoria else "está abaixo"
                print(f"{i}. {jogador.name}: {jogador.victory_percentage}% vitórias "
                      f"comparado com a média de {media_vitoria}% {comparacao} da mesma.")

            input("\nPressione qualquer tecla para voltar ao menu...")
