import random
from card import Card

class Deck:
    def __init__(self):
        self.deck = []  # Inicializa o baralho vazio
        self.build_deck()
        self.shuffle_deck()

    # Cria todas as cartas do baralho
    def build_deck(self):
        suits = ['♦', '♣', '♥', '♠']  # Define naipes das cartas
        values = ["Ás", "2", "3", "4", "5", "6", "7", "8", "9", "10", "Valete", "Rainha", "Rei"]  # Define valores das cartas
        self.deck = [Card(value, suit) for suit in suits for value in values]

    # Embaralha as cartas do baralho
    def shuffle_deck(self):
        random.shuffle(self.deck)

    # Distribui uma carta, se houver cartas no baralho
    def deal_card(self):
        return self.deck.pop() if self.deck else None
