from deck import Deck
from player import Player, Dealer
from utils import limpar_ecra
from classificacoes import Classificacoes

class Game:
    def __init__(self):
        # Inicializa o jogo, criando o baralho, jogadores e o dealer
        self.deck = Deck()
        self.players = []
        self.dealer = Dealer()
        self.actions = {}
        self.turno = 1
        self.game_over = False
        self.classificacoes = Classificacoes()

        from utils import numero_jogadores, dificuldade_atual
        # Cria os jogadores humanos
        for i in range(numero_jogadores):
            print(f"Número de jogadores Humanos: {numero_jogadores}\n")
            jogador_nome = ""
            while jogador_nome == "" or (dificuldade_atual == "Impossível" and jogador_nome == "Kaxeszer"):
                jogador_nome = input(f"Insira o nome do Jogador {i + 1}: ")
                if jogador_nome == "Dealer":
                    print("Já há um Dealer no jogo. Tente novamente.")
                    jogador_nome = ""
                if dificuldade_atual == "Impossível" and jogador_nome == "Kaxeszer":
                    print("Kaxeszer não tem impossibilidades. Tente novamente.")
                    jogador_nome = ""
                if numero_jogadores > 1 and jogador_nome == "Kaxeszer":
                    print("Kaxeszer só joga sozinho")
                    jogador_nome = ""
            self.players.append(Player(jogador_nome))

    def restart_game(self):
        # Reinicia o jogo, limpando as mãos dos jogadores e do dealer
        for player in self.players:
            player.clear_hand()  # Limpa as cartas do jogador
        self.dealer.clear_hand()  # Limpa as cartas do dealer

        self.deck.build_deck()  # Cria um novo baralho
        self.deck.shuffle_deck()  # Embaralha o baralho
        self.players = [Player(player.name) for player in self.players]  # Reinicia os jogadores (novos objetos)
        self.dealer = Dealer()  # Reinicia o dealer (novos objetos, sem as cartas anteriores)
        self.turno = 1  # Reinicia o turno
        self.game_over = False  # O jogo não acabou ainda

    def start_game(self):
        limpar_ecra()  # Limpa a ecrã
        from utils import dificuldade_atual
        self.restart_game()  # Reinicia o jogo
        self.deck.shuffle_deck()  # Embaralha o baralho

        # Distribui cartas iniciais alternadamente para cada jogador e o dealer
        for _ in range(2):  # Dá 2 cartas para cada jogador e dealer
            for player in self.players:
                player.add_card(self.deck.deal_card())  # Dá uma carta ao jogador
            self.dealer.add_card(self.deck.deal_card())  # Dá uma carta ao dealer

        # Verifica se cada jogador tem 2 cartas
        for player in self.players:
            if len(player.hand) != 2:
                print(f"Erro: {player.name} não tem 2 cartas!")
            else:
                # Verifica se o jogador é o "Kaxeszer" e garante que ele tenha 21
                player_value = player.calculate_hand_value()
                dealer_value = self.dealer.calculate_hand_value(reveal_dealer=True)
                if player.name == 'Kaxeszer':
                    while player_value != 21:
                        player.clear_hand()
                        self.deck.build_deck()
                        self.deck.shuffle_deck()
                        player.add_card(self.deck.deal_card())
                        player.add_card(self.deck.deal_card())
                        player_value = player.calculate_hand_value()
                    self.game_over = True
        # Verifica se o dealer tem 2 cartas
        if len(self.dealer.hand) != 2:
            print("Erro: O Dealer não tem 2 cartas!")
        else:
            # Verifica se a dificuldade é "Impossível" e garante que o dealer tenha 21
            if dificuldade_atual == 'Impossível':
                while dealer_value != 21:
                    self.dealer.clear_hand()
                    self.deck.build_deck()
                    self.deck.shuffle_deck()
                    self.dealer.add_card(self.deck.deal_card())
                    self.dealer.add_card(self.deck.deal_card())
                    dealer_value = self.dealer.calculate_hand_value(reveal_dealer=True)
                self.game_over = True

        print("\n===== Cartas Iniciais =====")
        for player in self.players:
            print(f"{player.name}: {player.show_hand()}")
        print(f"Dealer: {self.dealer.show_hand(reveal_dealer=False)}")
        input("\nPressione qualquer tecla para continuar...")
        if player.has_blackjack() or self.dealer.has_blackjack() or player.has_busted() or self.dealer.has_busted():
            self.game_over = True

        # Enquanto o jogo não terminar
        while not self.game_over:
            print(f"\n===== Turno {self.turno} =====")

            # Processa o turno de cada jogador e alternado com o dealer
            for player in self.players:
                if not player.has_busted() and not player.has_stayed() and not player.has_folded() and not player.has_blackjack():
                    print(f"\nTurno de {player.name}:")
                    action = player.take_action()
                    if action == "P":
                        player.add_card(self.deck.deal_card())
                        print(f"{player.name} pediu carta!")
                    elif action == "F":
                        print(f"{player.name} escolheu ficar.")
                        player.stayed = True
                    elif action == "D":
                        print(f"{player.name} escolheu desistir.")
                        player.folded = True

            # Turno do dealer alternado com o jogador
            if not self.dealer.has_busted() and not self.dealer.has_stayed():
                print("\nTurno do Dealer:")
                action = self.dealer.take_action(self.deck)
                if action == "P":
                    self.dealer.add_card(self.deck.deal_card())
                    print("Dealer pediu carta.")
                else:
                    self.dealer.stayed = True
                    print("Dealer escolheu ficar.")

            # Exibe as mãos atualizadas após o turno
            print("\n===== Mãos Atualizadas =====")
            for player in self.players:
                print(f"{player.name}: {player.show_hand()}")
            print(f"Dealer: {self.dealer.show_hand(reveal_dealer=False)}")
            input("\nPressione qualquer tecla para continuar...")

            # Condições de término do jogo
            if self.dealer.has_blackjack() or self.dealer.has_busted():
                self.game_over = True  # Encerra o jogo
            elif all(player.has_blackjack() for player in self.players) or all(
                    player.has_busted() for player in self.players):
                self.game_over = True  # Encerra o jogo
            elif all(player.has_folded() or player.has_busted() or player.has_stayed() for player in
                     self.players) and self.dealer.has_stayed():
                self.game_over = True  # Encerra o jogo
            else:
                self.turno += 1  # Avança para o próximo turno

        # Exibe os resultados finais
        self.exibir_resultados()

    def exibir_resultados(self):
        limpar_ecra()  # Limpa a ecrã para mostrar os resultados
        print("\n===== RESULTADOS =====")
        from utils import BLACKJACK
        dealer_value = self.dealer.calculate_hand_value(reveal_dealer=True)  # Calcula o valor do dealer uma vez

        for player in self.players:
            player_value = player.calculate_hand_value()  # Calcula o valor da mão do jogador

            print(f"{player.name}: {player.show_hand()}")

            # Aqui, mostramos a mão completa do dealer ao final do jogo
            print(f"Dealer: {self.dealer.show_hand(reveal_dealer=True)}")

            # Exibe o resultado para cada jogador
            if player.has_folded():
                print(f"{player.name} perdeu! Desistiu.\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif player.has_busted():
                print(f"{player.name} perdeu! Estourou.\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif player_value == BLACKJACK:
                print(f"{player.name} venceu! BlackJack!\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=True)
            elif dealer_value == BLACKJACK:
                print(f"{player.name} perdeu! O Dealer tem BlackJack!\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif player_value > 21:
                print(f"{player.name} perdeu! Você estourou.\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif dealer_value > 21:
                print(f"{player.name} venceu! O Dealer estourou.\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=True)
            elif player_value > dealer_value:
                print(f"{player.name} venceu!\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=True)
            elif player_value < dealer_value:
                print(f"{player.name} perdeu! O Dealer ganhou.\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif player_value == dealer_value:
                print(f"{player.name} empatou com o Dealer.\n")
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)

        # Pergunta se o jogador quer jogar novamente ou voltar ao menu
        while True:
            escolha = input("\nDeseja jogar mais uma vez (J) ou voltar ao menu (M)? ").upper()
            if escolha == "J":  # Jogar novamente
                self.start_game()
                break
            elif escolha == "M":  # Voltar ao menu
                from menu import menu
                menu()
                break
            else:
                print("Escolha inválida. Por favor, digite 'J' para jogar novamente ou 'M' para voltar ao menu.")
