from game import Game  # Importa a classe que gerencia o jogo
from screen import goodbye_screen, regras_screen, about_screen  # Importa funções para exibir diferentes ecrãs
from utils import definir_dificuldade, limpar_ecra, definir_jogadores  # Importa funções auxiliares
from classificacoes import Classificacoes  # Importa a classe que gerencia as classificações

def menu():
    from utils import dificuldade_atual, numero_jogadores  # Importa a dificuldade e o número de jogadores atuais
    while True:
        limpar_ecra()  # Limpa o ecrã
        print("""
        Bem-vindo ao MENU do BLACKJACK 21!

        1. Jogar
        2. Opções
        3. Classificações
        4. Regras
        5. Sobre
        6. Sair
        """)
        print(f"\nDificuldade Atual: {dificuldade_atual}")  # Exibe a dificuldade atual
        print(f"Número de jogadores Humanos: {numero_jogadores}\n")  # Exibe o número de jogadores humanos
        escolha = input("Escolha uma opção: ")  # Solicita a escolha do usuário

        if escolha == '1':  # Caso escolha jogar
            limpar_ecra()  # Limpa o ecrã
            jogo = Game()  # Cria uma nova instância do jogo
            jogo.start_game()  # Inicia o jogo
        elif escolha == '2':  # Caso escolha opções
            limpar_ecra()  # Limpa o ecrã
            menu_opcoes()  # Exibe o menu de opções
        elif escolha == '3':  # Caso escolha classificações
            limpar_ecra()  # Limpa o ecrã
            classificacoes = Classificacoes()  # Cria uma instância de classificações
            classificacoes.mostrar_classificacoes()
        elif escolha == '4':  # Caso escolha regras
            limpar_ecra()  # Limpa o ecrã
            regras_screen()  # Exibe as regras do jogo
        elif escolha == '5':  # Caso escolha sobre
            limpar_ecra()  # Limpa o ecrã
            about_screen()  # Exibe informações sobre o jogo
        elif escolha == '6':  # Caso escolha sair
            limpar_ecra()  # Limpa o ecrã
            goodbye_screen()  # Exibe a ecrã de despedida
            exit()  # Encerra o programa
        else:  # Caso escolha uma opção inválida
            print("Opção inválida. Tente novamente.")  # Informa que a opção é inválida
            input("\nPressione qualquer tecla para continuar...")  # Aguarda o input do usuário
            menu()  # Reinicia o menu

def menu_opcoes():
    while True:
        limpar_ecra()  # Limpa o ecrã
        print("\nMENU DE OPÇÕES")
        print("1. Definir Dificuldade")
        print("2. Definir Número de Jogadores")
        print("3. Voltar ao Menu Principal")

        escolha = input("\nEscolha uma opção: ")  # Solicita a escolha do usuário

        if escolha == '1':  # Caso escolha definir dificuldade
            limpar_ecra()  # Limpa o ecrã
            menu_dificuldade()  # Exibe o menu para definir a dificuldade
        elif escolha == '2':  # Caso escolha definir número de jogadores
            limpar_ecra()  # Limpa o ecrã
            menu_jogadores()  # Exibe o menu para definir o número de jogadores
        elif escolha == '3':  # Caso escolha voltar ao menu principal
            menu()  # Exibe o menu principal
        else:  # Caso escolha uma opção inválida
            print("\nOpção inválida. Tente novamente.")  # Informa que a opção é inválida
            input("\nPressione qualquer tecla para continuar...")  # Aguarda o input do usuário

def menu_dificuldade():
    while True:
        limpar_ecra()  # Limpa o ecrã
        dificuldades = {  # Define as dificuldades disponíveis
            '1': 'Fácil',
            '2': 'Moderado',
            '3': 'Difícil',
            '4': 'Impossível'
        }

        print("\nESCOLHER DIFICULDADE")
        for num, nivel in dificuldades.items():  # Exibe as dificuldades
            print(f"{num}. {nivel}")

        escolha = input("\nEscolha a dificuldade (1-4): ")  # Solicita a escolha do usuário

        if escolha in dificuldades:  # Caso a escolha seja válida
            nova_dificuldade = dificuldades[escolha]  # Define a nova dificuldade
            definir_dificuldade(nova_dificuldade)  # Aplica a nova dificuldade
            input("Pressione qualquer tecla para voltar ao menu de opções...")  # Aguarda o input do usuário
            limpar_ecra()  # Limpa o ecrã
            menu_opcoes()  # Exibe o menu de opções
        else:  # Caso a escolha seja inválida
            print("\nOpção inválida. Tente novamente.")  # Informa que a opção é inválida
            input("Pressione qualquer tecla para continuar...")  # Aguarda o input do usuário
            menu_dificuldade()  # Reinicia o menu de dificuldade

def menu_jogadores():
    global numero_jogadores  # Permite modificar o número de jogadores globalmente
    while True:
        limpar_ecra()  # Limpa o ecrã
        print("\nESCOLHER NÚMERO DE JOGADORES")
        print("1. 1 Jogador")
        print("2. 2 Jogadores")
        print("3. 3 Jogadores")

        escolha = input("\nEscolha o número de jogadores (1-3): ")  # Solicita a escolha do número de jogadores

        if escolha == '1':  # Caso escolha 1 jogador
            definir_jogadores(1)  # Define o número de jogadores para 1
            print("\nNúmero de jogadores definido para 1.")  # Informa que o número de jogadores foi definido para 1
            input("Pressione qualquer tecla para voltar ao menu de opções...")  # Aguarda o input do usuário
            menu_opcoes()  # Exibe o menu de opções
        elif escolha == '2':  # Caso escolha 2 jogadores
            definir_jogadores(2)  # Define o número de jogadores para 2
            print("\nNúmero de jogadores definido para 2.")  # Informa que o número de jogadores foi definido para 2
            input("Pressione qualquer tecla para voltar ao menu de opções...")  # Aguarda o input do usuário
            menu_opcoes()  # Exibe o menu de opções
        elif escolha == '3':  # Caso escolha 3 jogadores
            definir_jogadores(3)  # Define o número de jogadores para 3
            print("\nNúmero de jogadores definido para 3.")  # Informa que o número de jogadores foi definido para 3
            input("Pressione qualquer tecla para voltar ao menu de opções...")  # Aguarda o input do usuário
            menu_opcoes()  # Exibe o menu de opções
        else:  # Caso escolha uma opção inválida
            print("\nOpção inválida. Tente novamente.")  # Informa que a opção é inválida
            input("Pressione qualquer tecla para continuar...")  # Aguarda o input do usuário
            menu_jogadores()  # Reinicia o menu de jogadores
