import os

def limpar_ecra():
    os.environ['TERM'] = 'xterm-256color'  # Define a variável de ambiente TERM

    # Limpa a consola, dependendo do sistema operativo
    sistema = os.name  # Verifica o sistema operativo
    if sistema == 'nt':  # Se for Windows
        os.system('cls')  # Limpa a consola no Windows
    else:
        os.system('clear')  # Limpa a consola no Linux/Mac

# Constantes do jogo
DEALER_STOPS = {
    'Fácil': 15,  # Limite para o dealer na dificuldade fácil
    'Moderado': 17,  # Limite para o dealer na dificuldade moderada
    'Difícil': 18,  # Limite para o dealer na dificuldade difícil
    'Impossível': 21  # Limite para o dealer na dificuldade impossível
}
BLACKJACK = 21  # Valor do Blackjack

# Dificuldade padrão
dificuldade_atual = 'Moderado'

# Jogadores humanos padrão
numero_jogadores = 1

def definir_jogadores(novo_numero_jogadores):
    global numero_jogadores  # Acede à variável global número de jogadores
    numero_jogadores = novo_numero_jogadores  # Define o novo número de jogadores

def definir_dificuldade(nova_dificuldade):
    global dificuldade_atual, DEALER_LIMIT  # Acede às variáveis globais de dificuldade e limite do dealer
    dificuldade_atual = nova_dificuldade  # Define a nova dificuldade
    DEALER_LIMIT = DEALER_STOPS[nova_dificuldade]  # Atualiza o limite do dealer conforme a dificuldade
    print(f"\nDificuldade alterada para {dificuldade_atual}.")  # Exibe a dificuldade alterada

DEALER_LIMIT = DEALER_STOPS[dificuldade_atual]  # Define o limite do dealer conforme a dificuldade atual
