/*
** file: avp.c
**
** UC: 21111 - Sistemas Operativos
** e-folio A 2024-25
** Árvore de processos
** Versão template
**
** Utilização: ./avp
** Compilar:   gcc -Wall -std=c99 -o avp avp.c
**
** Aluno: 2405276 - Hugo Correia
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

// Indicar nº aluno para definir o problema que lhe foi atribuido
#define NUMALUNO          2405276

//------------------------------------------------------------------------------
// problema 0: árvore A(B,C,D) C(E)
//------------------------------------------------------------------------------
void prob0()
{
    pid_t pid,pidE;
    int i;
    char *processos="ABCD";  //atribui uma letra a cada processo e define o tamanho do loop

    printf("Problema 0\n");
    printf("Processo A: PID=%5d  PPID=%5d\n",(int) getpid(), (int) getppid());
    for(i=1; i<strlen(processos); i++) {  //loop de 1(B) até 3(D)
        pid= fork();
        if (pid==-1) {
            perror("Erro na funcao fork()");
            exit(1);
        }
        if (pid==0) {       //Zero é o result do proprio child quando é criado com sucesso
            printf("Processo %c: PID=%5d  PPID=%5d\n",processos[i],(int) getpid(), (int) getppid());
            if (processos[i]=='C') { //como estamos no problema 0, temos de criar um child E no processo 'C'
                fflush(stdout);
                pidE = fork();
                if (pidE==-1) {
                    perror("Erro na funcao fork()");
                    exit(1);
                }
                if (pidE == 0) {
                    printf("Processo E: PID=%5d  PPID=%5d\n",(int) getpid(), (int) getppid());
                    exit(0);    //sair do processo atual (E)
                } else {
                    wait(NULL); //aguardar o termino do child
                }
            }
            exit(0);        //sair do processo atual [i]
        } else {
            wait(NULL);     //aguardar o termino do child
        }
    }
}


//------------------------------------------------------------------------------
// problema 1: árvore A(B,C,D) D(E)
//------------------------------------------------------------------------------
void prob1()
{
   // Insira aqui o código para a solução do problema 1
}


int main(int argc, char *argv[])
{
   int prob= NUMALUNO % 2;

   if( prob==0 )
      prob0();    // aluno com nº par
   else
      prob1();    // aluno com nº impar
   return 0;
}

// EOF
