%
% efb_sor.m
% UC 21180 - Computação Numérica | e-fólio B
% Luís Pereira | 2300163
% Questão 1.3
%

% Limpeza do workspace e da janela de comandos
clear;
clc;

% Dimensão do sistema linear
n = 100;

% Construção da matriz A tridiagonal estritamente dominante
A = 4 * eye(n) - diag(ones(n-1,1),1) - diag(ones(n-1,1),-1);

% Definição da solução exata do sistema
x_exato = ones(n,1);

% Cálculo do termo independente b
b = A * x_exato;

% Verificação da dominância diagonal da matriz A
% (chama a função da Questão 1.1 - verif_dominancia)
[is_dom, r] = verif_dominancia(A);

% Apresentação do resultado da verificação
if is_dom
  fprintf('A matriz é estritamente dominante diagonalmente.\n');
else
  fprintf('A matriz NÃO é estritamente dominante diagonalmente.\n');
end

% Definição dos parâmetros do método SOR
% estimativa inicial
x0 = zeros(n,1);

% tolerância de paragem
tol = 1e-6;

% número máximo de iterações
max_iter = 10000;

% Valores do parâmetro de relaxamento a considerar
omegas = [1.0, 1.25, 1.8];

% Cabeçalho da tabela de resultados
fprintf('\n %5s  |  %9s  |  %9s  | %5s\n', 'omega', 'iteracoes', 'tempo (s)', 'erro');
fprintf('------------------------------------------------\n');

% Ciclo para aplicação do método SOR a diferentes valores de omega
for k = 1:length(omegas)
  omega = omegas(k);

  % Aplicação do método SOR
  % (chama a função da Questão 1.2 - solve_sor)
  tic;
  [x, iter] = solve_sor(A, b, omega, x0, tol, max_iter);
  tempo = toc;

  % Cálculo do erro final em norma infinito
  erro = norm(x - x_exato, inf);

  % Apresentação dos resultados obtidos
  fprintf(' %5.2f  |  %9d  |  %9.4f  |  %5.2e\n', omega, iter, tempo, erro);
end
% EOF

