function [x, iter] = solve_sor(A, b, omega, x0, tol, max_iter)
%
% Resolve Ax=b pelo método SOR
% omega: fator de relaxamento
% x0:    estimativa inicial
% tol:   tolerância de paragem (norma infinito do erro entre iterações)
% x:     vetor solução; iter: número de iterações realizadas
%
% solve_sor.m
% UC 21180 - Computação Numérica | e-fólio B
% Luís Pereira | 2300163
% Questão 1.2
%

  % Número de equações do sistema
  n = length(b);

  % Inicialização do vetor solução com a estimativa inicial
  x = x0(:);

  % Ciclo principal de iterações do método SOR
  for iter = 1:max_iter

    % Guarda a solução da iteração anterior
    x_old = x;

    % Ciclo pelas componentes do vetor solução
    for i = 1:n

      % Cálculo da soma com os valores já atualizados (j < i)
      s1 = A(i,1:i-1) * x(1:i-1);

      % Cálculo da soma com os valores da iteração anterior (j > i)
      s2 = A(i,i+1:n) * x_old(i+1:n);

      % Verificação de elemento diagonal nulo
      if A(i,i) == 0
        error('A tem elemento diagonal nulo.');
      end

      % Atualização da componente i do vetor solução segundo o método SOR
      x(i) = (1 - omega) * x_old(i) + ...
             (omega / A(i,i)) * (b(i) - s1 - s2);
    end

    % Verificação do critério de paragem
    % Compara a diferença entre iterações consecutivas
    if norm(x - x_old, inf) < tol
      return
    end
  end

  % Aviso caso o número máximo de iterações seja atingido sem convergência
  fprintf('A precisão desejada não foi atingida dentro do número máximo de iterações.\n');

end
% EOF

