function [is_dom, r] = verif_dominancia(A)
%
% Verifica se a matriz A é estritamente dominante diagonalmente
% A:       Matriz quadrada de coeficientes
% is_dom:  booleano (true se for dominante, false caso contrário)
% r:       vetor com a razão (soma extra-diagonal / diagonal) por linha
%
% verif_dominancia.m
% UC 21180 - Computação Numérica | e-fólio B
% Luís Pereira | 2300163
% Questão 1.1
%

  % Verificação se a matriz A é quadrada
  if rows(A) != columns(A)
    error('A deve ser quadrada');
  end

  % Cálculo dos valores absolutos dos elementos da diagonal principal
  d = abs(diag(A));

  % Cálculo da soma dos valores absolutos fora da diagonal, por linha
  s = sum(abs(A), 2) - d;

  % Inicialização do vetor r
  r = Inf(size(d));

  % Identificação das posições com elementos diagonais não nulos
  idx = (d > 0);

  % Cálculo do rácio (soma extra-diagonal / diagonal) por linha
  r(idx) = s(idx) ./ d(idx);

  % Verificação da condição de dominância diagonal estrita por linhas
  is_dom = all(d > s);

end
% EOF

