import random

class Card:
    def __init__(self, value, suit):
        self.value = value
        self.suit = suit

    def __str__(self):
        return f"{self.value} de {self.suit}"

class Deck:
    def __init__(self):
            self.deck = []
            self.build_deck()

    def build_deck(self):
            suits = ['♦', '♣', '♥', '♠']
            values = ["Ás", "2", "3", "4", "5", "6", "7", "8", "9", "10", "Valete", "Rainha", "Rei"]
            self.deck = [Card(value, suit) for suit in suits for value in values]

    def shuffle_deck(self):
            random.shuffle(self.deck)

    def deal_card(self):
            return self.deck.pop() if self.deck else None

class Game:
    def __init__(self):
        self.deck = Deck()
        self.player = Player("Jogador")
        self.dealer = Player("Dealer")

    def start_game(self):
        self.deck.shuffle_deck()

        # Distribui 2 cartas para cada jogador
        for _ in range(2):
            self.player.add_card(self.deck.deal_card())
            self.dealer.add_card(self.deck.deal_card())

        # Mostra as mãos iniciais
        print(f"Jogador: {self.player.show_hand()}")
        print(f"Dealer: {self.dealer.show_hand()}")

        # Implementar as regras do jogo aqui

class Player:
    def __init__(self, name):
        self.name = name
        self.hand = []

    def add_card(self, card):
        self.hand.append(card)

    def show_hand(self):
        return ", ".join(str(card) for card in self.hand)

def main():
    jogo = Game()
    jogo.start_game()

if __name__ == "__main__":
    main()