% efa22_1.m
% Gráfico do erro absoluto do volume εV(r)

clear; clc; close all;

% Parâmetros do problema
h  = 2;          % altura medida
rh = 0.001;      % erro relativo da altura (0.1%)
er = 0.01;       % erro absoluto do raio

% Intervalo de r para análise
r = linspace(0, 10, 200);

% Coeficientes da expressão εV(r)
coef_r  = (2*pi*h/3) * er;
coef_r2 = (pi*h/3)   * rh;

% Função do erro absoluto
eV = coef_r .* r + coef_r2 .* (r.^2);

% Gráfico
figure(1);
plot(r, eV, 'b-', 'LineWidth', 1.4);  % linha mais bonita
grid on;

xlabel('r');
ylabel('\epsilon_V(r)');
title('Erro absoluto do volume em função do raio');
legend('\epsilon_V(r)', 'Location', 'northwest');
