% efa22_2.m
% Método do ponto fixo para estimar r_max com εV(r) = 0.3

clear; clc;

% Parâmetros do problema
h   = 2;          % altura medida
rh  = 0.001;      % erro relativo da altura
er  = 0.01;       % erro absoluto do raio
epsMax = 0.3;     % erro máximo permitido

% Função iteradora f(r)
f = @(r) ( (3*epsMax)/(pi*h) - r.^2 * rh ) / (2*er);

% Constante de contracção (limite para |f'(r)|)
q = 0.9;    
errFactor = q / (1 - q);   % para estimar |r* - rk|

% Estimativa inicial
rOld = 0.1;

fprintf('k\t        r_k\t\t    erro absoluto (estimado)\n');
fprintf('0\t% .10f\t\t    n/a\n', rOld);

% Iterações
maxIter = 50;
for k = 1:maxIter
    
    % aplicar f
    rNew = f(rOld);
    
    % estimativa do erro usando eq. (1.24)
    estErr = errFactor * abs(rNew - rOld);
    
    fprintf('%d\t% .10f\t    % .10e\n', k, rNew, estErr);
    
    % critério para 5 algarismos significativos
    if estErr < 5e-6
        break;
    end
    
    rOld = rNew;
end