% efa22_2.m
% Efolio-A 2025 - Luís Pereira 2300163
% Questao 1.4
%
% Metodo do ponto fixo para estimar r_max
% com pelo menos 5 algarismos significativos
%
% f(r) = 0.9 / (0.04*pi + 0.002*pi*r)
% L = 0.36  (constante de Lipschitz)
% Erro absoluto estimado: e_k = (L/(1-L))*abs(r_k - r_{k-1})

% Inicia com variaveis e consola limpa (Clean workspace)
clear; clc;

% Funcao iteradora
f = @(r) 0.9 ./ (0.04*pi + 0.002*pi*r);

% Constante L
L = 0.36;

% Estimativa inicial
r0 = 0.1;
r1 = f(r0);

% Erro estimado pela fórmula 1.24 (termo do meio)
e_k = (L/(1-L)) * abs(r1 - r0);

% Cabeçalhos da tabela
fprintf("\n---------- Metodo do Ponto Fixo ----------\n");
fprintf("  k            r_k                 erro\n");

% Primeira linha (sem erro)
fprintf(" %2d   %20.15f\n", 0, r0);

% Segunda linha (primeiro erro)
fprintf(" %2d   %20.15f    %10.3e\n", 1, r1, e_k);

% Variáveis da iteração
k = 1;
rk_1 = r1;
rk_0 = r0;

% Criterio para 5 algarismos significativos
dx_stop = 0.5e-5;

% Iterações seguintes até satisfazer o criterio
while (e_k > dx_stop)
    k = k + 1;
    r_new = f(rk_1);

    % Erro absoluto estimado pela fórmula 1.24
    e_new = (L/(1-L)) * abs(r_new - rk_1);

    fprintf(" %2d   %20.15f    %10.3e\n", k, r_new, e_new);

    % Atualizações para a próxima iteração
    rk_0 = rk_1;
    rk_1 = r_new;
    e_k = e_new;
end

% Resultados finais
fprintf("\nEstimativa final r_max = %.5g\n", rk_1);
fprintf("Erro final estimado = %.3e\n\n", e_k);

% EOF