class Card:
    def __init__(self, value, suit):
        self.value = value  # Valor da carta
        self.suit = suit  # Naipe da carta

    # Representação em formato de string da carta
    def __str__(self):
        return f"{self.value} de {self.suit}"

    # Devolve o valor das cartas
    def get_value(self):
        if self.value in ['J', 'Q', 'K']:  # Cartas com figuras valem 10
            return 10
        elif self.value == 'A':  # O Ás vale 1
            return 1
        else:
            return int(self.value)  # As outras cartas têm o valor numérico

    def generate_ascii(self):
        suit_symbol = self.suit
        value_display = self.value if len(self.value) == 2 else f"{self.value} "

        return [
            "┌─────────┐",
            f"│ {value_display:<2}      │",  # Valor no canto superior esquerdo
            "│         │",
            "│         │",
            f"│    {suit_symbol}    │",  # Símbolo do naipe no centro
            "│         │",
            "│         │",
            f"│      {value_display:>2} │",  # Valor no canto inferior direito
            "└─────────┘",
        ]