import random
import sound
from card import Card

class Deck:
    def __init__(self):
        self.deck = []  # Inicializa o baralho vazio
        self.build_deck()

    # Cria todas as cartas do baralho
    def build_deck(self):
        suits = ['♦', '♣', '♥', '♠']  # Define naipes das cartas
        values = ["A", "2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K"]  # Define valores das cartas
        self.deck = [Card(value, suit) for suit in suits for value in values]

    # Embaralha as cartas do baralho
    def shuffle_deck(self):
        sound.play_baralhar()
        random.shuffle(self.deck)

    # Distribui uma carta, se houver cartas no baralho
    def deal_card(self):
        sound.play_deal()
        return self.deck.pop() if self.deck else None