import tkinter as tk
import sound
from deck import Deck
from player import Player, Dealer
from classificacoes import Classificacoes

class Game:
    def __init__(self):
        # Inicializa o jogo, criando o baralho, jogadores e o dealer
        self.deck = Deck()
        self.players = []
        self.dealer = Dealer()
        self.actions = {}
        self.turno = 1
        self.game_over = False
        self.classificacoes = Classificacoes()

        from utils import numero_jogadores, dificuldade_atual
        # Cria os jogadores humanos
        for i in range(numero_jogadores):
            jogador_nome = ""
            while jogador_nome == "" or (dificuldade_atual == "Impossível" and jogador_nome == "Kaxeszer"):
                jogador_nome = self.coletar_nome(f"Insira o nome do Jogador {i + 1}: ")
                if jogador_nome == "Dealer":
                    self.mostrar_mensagem("Já há um Dealer no jogo. Tente novamente.")
                    jogador_nome = ""
                if dificuldade_atual == "Impossível" and jogador_nome == "Kaxeszer":
                    self.mostrar_mensagem("Kaxeszer não tem impossibilidades. Tente novamente.")
                    jogador_nome = ""
                if numero_jogadores > 1 and jogador_nome == "Kaxeszer":
                    self.mostrar_mensagem("Kaxeszer só joga sozinho")
                    jogador_nome = ""
            self.players.append(Player(jogador_nome))

    def coletar_nome(self, mensagem, largura=300, altura=300):
        nome_var = tk.StringVar() # Variável para armazenar o nome inserido pelo jogador

        def confirmar():
            nome_var.set(entry_nome.get())  # Define o valor da variável com o nome inserido
            janela_nome.destroy()  # Fecha a janela após a confirmação

        janela_nome = tk.Toplevel()  # Cria uma nova janela para inserir o nome
        janela_nome.geometry(f"{largura}x{altura}")  # Define tamanho da janela
        janela_nome.title("Nome do Jogador") # Define o título da janela
        tk.Label(janela_nome, text=mensagem).pack(pady=10)
        entry_nome = tk.Entry(janela_nome) # Campo de entrada para o jogador inserir o nome
        entry_nome.pack(pady=10)
        tk.Button(janela_nome, text="OK", command=confirmar).pack(pady=10) # Botão de confirmação
        janela_nome.wait_window()
        return nome_var.get() # Retorna o nome inserido pelo jogador

    def mostrar_mensagem(self, mensagem, largura=450, altura=300, titulo="Mensagem", opcoes=None, acao_callback=None):
        # Cria uma nova janela Toplevel
        janela_mensagem = tk.Toplevel()
        janela_mensagem.title(titulo)
        janela_mensagem.geometry(f"{largura}x{altura}")  # Define tamanho da janela

        # Adiciona o texto da mensagem
        tk.Label(janela_mensagem, text=mensagem, justify="left", font=("Courier", 12)).pack(pady=20, padx=20)

        # Adiciona botões para as opções, se fornecidas
        if opcoes and acao_callback:
            for opcao, acao in opcoes.items():
                tk.Button(
                    janela_mensagem,
                    text=opcao,
                    command=lambda a=acao: [acao_callback(a), janela_mensagem.destroy()]
                ).pack(pady=5)

        else:  # Caso não tenha opções, adiciona um botão "OK"
            tk.Button(janela_mensagem, text="OK", command=janela_mensagem.destroy).pack(pady=10)

        janela_mensagem.transient()  # Define como janela modal
        janela_mensagem.grab_set()  # Bloqueia interações com outras janelas até que esta seja fechada
        janela_mensagem.wait_window(janela_mensagem)  # Aguarda o fechamento da janela

    def restart_game(self):
        # Reinicia o jogo, limpando as mãos dos jogadores e do dealer
        for player in self.players:
            player.clear_hand()  # Limpa as cartas do jogador
        self.dealer.clear_hand()  # Limpa as cartas do dealer

        self.deck.build_deck()  # Cria um novo baralho
        self.deck.shuffle_deck()  # Embaralha o baralho
        self.players = [Player(player.name) for player in self.players]  # Reinicia os jogadores (novos objetos)
        self.dealer = Dealer()  # Reinicia o dealer (novos objetos, sem as cartas anteriores)
        self.turno = 1  # Reinicia o turno
        self.game_over = False  # O jogo não acabou ainda

       # Apenas para questão 1c
       # for jogador in self.players + [self.dealer]:
       #     texto = jogador.exibir_nome()  # Resposta 1c
       #     self.mostrar_mensagem(texto, largura=500, altura=500, titulo=f"===== Jogadores  =====")

    def easter_egg(self, player):
        player.clear_hand()  # Limpa a mão atual do jogador

        # Garante que o jogador receba um Ás e uma carta figura
        as_card = next(card for card in self.deck.deck if card.value == "A")
        figura_card = next(card for card in self.deck.deck if card.value in ["J", "Q", "K"])

        # Remove essas cartas do baralho
        self.deck.deck.remove(as_card)
        self.deck.deck.remove(figura_card)

        # Adiciona as cartas à mão do jogador
        player.add_card(as_card)
        player.add_card(figura_card)

        # Atualiza o valor da mão do jogador após adicionar as cartas
        player.calculate_hand_value()

    def start_game(self):
        from utils import dificuldade_atual
        self.restart_game()  # Reinicia o jogo

        # Distribui cartas iniciais alternadamente para cada jogador e o dealer
        for _ in range(2):  # Dá 2 cartas para cada jogador e dealer
            for player in self.players:
                player.add_card(self.deck.deal_card())  # Dá uma carta ao jogador
            self.dealer.add_card(self.deck.deal_card())  # Dá uma carta ao dealer

        # Verifica se cada jogador tem 2 cartas
        for player in self.players:
            if len(player.hand) != 2:
                self.mostrar_mensagem(f"Erro: {player.name} não tem 2 cartas!")
            else:
                # Verifica se o jogador é o "Kaxeszer" e garante que ele tenha 21
                player_value = player.calculate_hand_value()
                dealer_value = self.dealer.calculate_hand_value(reveal_dealer=True)
                if player.name == 'Kaxeszer' and player_value !=21:
                    self.easter_egg(player)
                    self.game_over = True

        # Verifica se o dealer tem 2 cartas
        if len(self.dealer.hand) != 2:
            self.mostrar_mensagem("Erro: O Dealer não tem 2 cartas!")
        else:
            # Verifica se a dificuldade é "Impossível" e garante que o dealer tenha 21
            if dificuldade_atual == 'Impossível' and dealer_value != 21:
                self.easter_egg(self.dealer)
                self.game_over = True

        # Mostra as cartas iniciais de todos os jogadores
        texto = ""
        for player in self.players:
            texto += f"\n{player.name}: \n{player.show_hand()}\n"
        texto += f"Dealer: \n{self.dealer.show_hand(reveal_dealer=False)}"
        self.mostrar_mensagem(texto, largura=600, altura=850, titulo="===== Cartas Iniciais =====")
        if player.has_blackjack() or self.dealer.has_blackjack() or player.has_busted() or self.dealer.has_busted():
            self.game_over = True

        # Enquanto o jogo não terminar
        while not self.game_over:
            # Processa o turno de cada jogador e alternado com o dealer
            texto = ""
            for player in self.players:
                if not player.has_busted() and not player.has_stayed() and not player.has_folded() and not player.has_blackjack():
                    texto += f"\nTurno de {player.name}:\n"
                    action = player.take_action(self.mostrar_mensagem, all_players=self.players + [self.dealer])
                    if action == "P":
                        player.add_card(self.deck.deal_card())
                        texto += f"{player.name} pediu carta!\n"
                    elif action == "F":
                        texto += f"{player.name} escolheu ficar.\n"
                        player.stayed = True
                    elif action == "D":
                        texto += f"{player.name} escolheu desistir.\n"
                        player.folded = True
                elif player.has_stayed() or player.has_folded():
                    texto += f"\nTurno de {player.name}:\n"
                    texto += f"{player.name} escolheu ficar ou desistir num turno anterior.\n"
                elif player.has_blackjack():
                    texto += f"\nTurno de {player.name}:\n"
                    texto += f"{player.name} têm BLACKJACK!\n"
                elif player.has_busted():
                    texto += f"\nTurno de {player.name}:\n"
                    texto += f"{player.name} já estourou no turno anterior.\n"

            # Turno do dealer alternado com o jogador
            if self.dealer.has_stayed():
                texto += "\nTurno do Dealer:\n"
                texto += "Dealer escolheu ficar ou desistir num turno anterior"
            if not self.dealer.has_busted() and not self.dealer.has_stayed():
                texto += "\nTurno do Dealer:\n"
                action = self.dealer.take_action(self.deck)
                if action == "P":
                    self.dealer.add_card(self.deck.deal_card())
                    texto += "Dealer pediu carta!\n"
                else:
                    self.dealer.stayed = True
                    texto += "Dealer escolheu ficar.\n"
            self.mostrar_mensagem(texto, largura=500, altura=500, titulo=f"===== Turno {self.turno} =====")

            # Exibe as mãos atualizadas após o turno
            texto = ""
            for player in self.players:
                texto += f"\n{player.name}: \n{player.show_hand()}\n"
            texto += f"Dealer: \n{self.dealer.show_hand(reveal_dealer=False)}"
            self.mostrar_mensagem(texto, largura=600, altura=850, titulo="===== Mãos Atualizadas =====")

            # Condições de término do jogo
            if self.dealer.has_blackjack() or self.dealer.has_busted():
                self.game_over = True  # Encerra o jogo
            elif all(player.has_folded() or player.has_busted() or player.has_stayed()
                     or player.has_blackjack() for player in
                     self.players) and self.dealer.has_stayed():
                self.game_over = True  # Encerra o jogo
            else:
                self.turno += 1  # Avança para o próximo turno

        # Exibe os resultados finais
        self.exibir_resultados()

    def exibir_resultados(self):
        from utils import BLACKJACK
        dealer_value = self.dealer.calculate_hand_value(reveal_dealer=True)  # Calcula o valor do dealer uma vez

        texto =""
        for player in self.players:
            player_value = player.calculate_hand_value()  # Calcula o valor da mão do jogador

            texto += f"\n{player.name}: \n{player.show_hand()}"

            # Exibe o resultado para cada jogador
            if player.has_folded():
                texto += f"\n{player.name} perdeu! Desistiu.\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif player.has_busted():
                texto += f"\n{player.name} perdeu! Estourou.\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif player_value == BLACKJACK:
                sound.play_blackjack()
                texto += f"\n{player.name} venceu! BlackJack!\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=True)
            elif dealer_value == BLACKJACK:
                texto += f"\n{player.name} perdeu! O Dealer tem BlackJack!\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
                sound.play_dealer()
            elif player_value > 21:
                texto += f"\n{player.name} perdeu! Você estourou.\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif dealer_value > 21:
                texto += f"\n{player.name} venceu! O Dealer estourou.\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=True)
            elif player_value > dealer_value:
                texto += f"\n{player.name} venceu!\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=True)
            elif player_value < dealer_value:
                texto += f"\n{player.name} perdeu! O Dealer ganhou.\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)
            elif player_value == dealer_value:
                texto += f"\n{player.name} empatou com o Dealer.\n"
                self.classificacoes.atualizar_classificacoes(player.name, venceu=False)

        # Aqui, mostramos a mão completa do dealer ao final do jogo
        texto += f"\nDealer: \n{self.dealer.show_hand(reveal_dealer=True)}\n"
        self.mostrar_mensagem(texto, largura=600, altura=850, titulo="===== RESULTADOS ====")

        # Pergunta se o jogador quer jogar novamente ou voltar ao menu
        while True:
            escolha = None  # Inicializa a variável de escolha
            janela_acao = tk.Toplevel()
            janela_acao.title("Continuar")

            # Label de mensagem
            tk.Label(
                janela_acao,
                text="Deseja jogar mais uma vez ou voltar ao menu?"
            ).pack(pady=10)

            # Função para definir a escolha e fechar a janela
            def definir_acao(acao):
                nonlocal escolha
                escolha = acao
                janela_acao.destroy()

            # Botões para as ações
            tk.Button(janela_acao, text="Jogar Novamente", command=lambda: definir_acao("J")).pack(pady=5)
            tk.Button(janela_acao, text="Voltar ao Menu", command=lambda: definir_acao("M")).pack(pady=5)

            # Aguarda o fechamento da janela
            janela_acao.wait_window()

            # Processa a escolha feita pelo jogador
            if escolha == "J":  # Jogar novamente
                self.start_game()
                break
            elif escolha == "M":  # Voltar ao menu
                self.mostrar_mensagem("Voltando ao menu...")
                break  # Sai do loop