import tkinter as tk
from tkinter import messagebox
import utils
from game import Game
from classificacoes import Classificacoes
from screen import welcome_screen, goodbye_screen, regras_screen, about_screen

# Função para inicializar a janela principal
def iniciar_interface():
    # Cria a janela principal como Tk
    janela = tk.Tk()
    janela.title("Blackjack 21")

    # Variáveis globais para dificuldade e número de jogadores
    dificuldade_atual = tk.StringVar(value=utils.dificuldade_atual)  # Valor padrão
    jogadores_atual = tk.StringVar(value=utils.numero_jogadores)  # Valor padrão

    def abrir_jogo():
        game = Game()
        game.start_game()

    def abrir_classificacoes():
        classificacoes = Classificacoes()
        classificacoes.mostrar_classificacoes(janela)  # Passa a janela principal como argumento

    def definir_dificuldade(atualizar_callback):
        def salvar_dificuldade():
            from utils import definir_dificuldade as set_dificuldade # Importa a função para definir a dificuldade
            dificuldade = dificuldade_var.get() # Obtém a dificuldade atual
            set_dificuldade(dificuldade)  # Atualiza a dificuldade
            tk.messagebox.showinfo("Dificuldade", f"Dificuldade definida para {dificuldade}")
            dificuldade_window.destroy()
            atualizar_callback() # Atualiza a interface (menu)

        dificuldade_window = tk.Toplevel(janela) # Cria uma nova janela para a escolha da dificuldade
        dificuldade_window.title("Definir Dificuldade")

        from utils import dificuldade_atual # Importa o nível de dificuldade atual
        dificuldade_var = tk.StringVar(value=dificuldade_atual) # Variável que armazena a dificuldade selecionada
        dificuldades = ["Fácil", "Moderado", "Difícil", "Impossível"] # Lista de níveis de dificuldade disponíveis

        tk.Label(dificuldade_window, text="Escolha a dificuldade:").pack(pady=10)
        for nivel in dificuldades: # Cria botões de seleção
            tk.Radiobutton(
                dificuldade_window, text=nivel, variable=dificuldade_var, value=nivel
            ).pack(anchor="w") # Exibe os botões de seleção alinhados à esquerda

        tk.Button(dificuldade_window, text="Salvar", command=salvar_dificuldade).pack(pady=10)

    def definir_jogadores(atualizar_callback):
        def salvar_jogadores():
            from utils import definir_jogadores as set_jogadores # Importa a função para definir o número de jogadores
            jogadores = int(jogadores_var.get()) # Obtém o número de jogadores selecionado
            set_jogadores(jogadores) # Atualiza o número de jogadores
            tk.messagebox.showinfo("Jogadores", f"Número de jogadores definido para {jogadores}")
            jogadores_window.destroy()
            atualizar_callback() # Atualiza a interface (menu)

        jogadores_window = tk.Toplevel(janela) # Cria uma nova janela para a escolha do número de jogadores
        jogadores_window.title("Definir Jogadores")

        from utils import numero_jogadores # Importa o número atual de jogadores
        jogadores_var = tk.IntVar(value=numero_jogadores)  # Variável que armazena o número de jogadores selecionado

        tk.Label(jogadores_window, text="Escolha o número de jogadores (1-3):").pack(pady=10)
        for i in range(1, 4): # Cria botões de seleção
            tk.Radiobutton(
                jogadores_window, text=f"{i} Jogador(es)", variable=jogadores_var, value=i
            ).pack(anchor="w") # Exibe os botões de seleção alinhados à esquerda

        tk.Button(jogadores_window, text="Salvar", command=salvar_jogadores).pack(pady=10) # Botão para guardar a escolha e fechar a janela

    # Abre a secção regras
    def abrir_regras():
        regras_window = tk.Toplevel(janela)
        regras_window.title("Regras do Blackjack 21")
        regras_window.geometry("400x400")
        regras_screen(regras_window)
        tk.Button(regras_window, text="Fechar", command=regras_window.destroy).pack(pady=10)

    # Abre a secção sobre
    def abrir_sobre():
        sobre_window = tk.Toplevel(janela)
        sobre_window.title("Sobre o Blackjack 21")
        sobre_window.geometry("400x400")
        about_screen(sobre_window)
        tk.Button(sobre_window, text="Fechar", command=sobre_window.destroy).pack(pady=10)

    def sair():
        for widget in janela.winfo_children():
            widget.destroy()  # Remove todos os widgets existentes
        goodbye_screen(janela)  # Exibe a tela de saída na mesma janela
        tk.Button(janela, text="Fechar", command=janela.destroy).pack(pady=20)  # Botão para encerrar o programa

    # Menu em tkinter
    def mostrar_menu():
        for widget in janela.winfo_children():
            widget.destroy()  # Remove todos os widgets existentes

        janela.geometry("400x600")  # Ajusta o tamanho para o menu principal
        tk.Label(janela, text="Blackjack 21!", font=("Helvetica", 16)).pack(pady=20)

        tk.Button(janela, text="Jogar", command=abrir_jogo, width=20, height=2).pack(pady=10)
        tk.Button(janela, text="Classificações", command=abrir_classificacoes, width=20, height=2).pack(pady=10)
        tk.Button(janela, text="Definir Dificuldade", command=lambda: definir_dificuldade(mostrar_menu), width=20,
                  height=2).pack(pady=10)
        tk.Button(janela, text="Definir Jogadores", command=lambda: definir_jogadores(mostrar_menu), width=20,
                  height=2).pack(pady=10)
        tk.Button(janela, text="Regras", command=abrir_regras, width=20, height=2).pack(pady=10)
        tk.Button(janela, text="Sobre", command=abrir_sobre, width=20, height=2).pack(pady=10)
        tk.Button(janela, text="Sair", command=sair, width=20, height=2).pack(pady=10)

        # Importa as variáveis atualizadas diretamente de utils
        from utils import dificuldade_atual, numero_jogadores

        # Exibe a dificuldade atual e o número de jogadores e a versão atual
        tk.Label(janela, text=f"Dificuldade Atual: {dificuldade_atual}", font=("Helvetica", 10)).pack(pady=5)
        tk.Label(janela, text=f"Número de Jogadores: {numero_jogadores}", font=("Helvetica", 10)).pack(pady=5)
        tk.Label(janela, text= "Versão 01.03", font=("Helvetica", 10)).pack(pady=5)

    def mostrar_boas_vindas():
        for widget in janela.winfo_children():
            widget.destroy()  # Remove todos os widgets existentes

        welcome_screen(janela)
        tk.Button(janela, text="OK", command=mostrar_menu).pack(pady=20)

    # Exibe a tela de boas-vindas inicialmente
    mostrar_boas_vindas()

    janela.mainloop()