import tkinter as tk

# Exibe o ecrã de boas-vindas na mesma janela
def welcome_screen(root):
    for widget in root.winfo_children():
        widget.destroy()  # Remove todos os widgets existentes

    root.geometry("500x500")  # Define o tamanho da janela de boas-vindas
    root.title("Bem-vindo ao Blackjack 21!")
    tk.Label(
        root,
        text="Bem-vindo ao BLACKJACK:\n\n"
             "┌─────────┐    ┌─────────┐\n"
             "│ A       │    │ K       │\n"
             "│         │    │         │\n"
             "│         │    │         │\n"
             "│    ♠    │    │    ♥    │\n"
             "│         │    │         │\n"
             "│         │    │         │\n"
             "│       A │    │      K  │\n"
             "└─────────┘    └─────────┘\n\n"
             "Pressione OK para começar...",
        font=("Courier", 12),
    ).pack(pady=20)

# Exibe o ecrã de adeus na mesma janela
def goodbye_screen(root):
    for widget in root.winfo_children():
        widget.destroy()  # Remove todos os widgets existentes

    root.geometry("500x500")  # Define o tamanho da janela de saída
    root.title("Até a próxima!")
    tk.Label(
        root,
        text="Até uma próxima vez!\n\n"
             "┌─────────┐    ┌─────────┐\n"
             "│ A       │    │ K       │\n"
             "│         │    │         │\n"
             "│         │    │         │\n"
             "│    ♠    │    │    ♥    │\n"
             "│         │    │         │\n"
             "│         │    │         │\n"
             "│       A │    │      K  │\n"
             "└─────────┘    └─────────┘\n\n"
             "Obrigado por jogar Blackjack 21!",
        font=("Courier", 12),
    ).pack(pady=20)

# Exibe o ecrã de regras
def regras_screen(root):
    for widget in root.winfo_children():
        widget.destroy()  # Remove todos os widgets existentes

    tk.Label(
        root,
        text="===== Regras do BLACKJACK 21 =====\n\n"
             "1. O objetivo é atingir o valor 21 sem ultrapassá-lo.\n"
             "2. Cada jogador recebe duas cartas. O dealer também.\n"
             "3. Valores das cartas:\n"
             "   - Numéricas: valor nominal.\n"
             "   - Figuras: 10 pontos.\n"
             "   - Ás: 1 ou 11 pontos.\n"
             "4. Durante sua vez:\n"
             "   - Pedir: Recebe outra carta.\n"
             "   - Ficar: Mantém a mão atual.\n"
             "   - Desistir: Perde a jogada.\n"
             "5. Dealer joga após os jogadores:\n"
             "   - Pede cartas até atingir o limite.\n"
             "   - Estoura se ultrapassar 21.\n\n"
             "Pressione 'Fechar' para retornar ao menu.",
        justify="left",
        font=("Helvetica", 10),
    ).pack(pady=10)

# Exibe o ecrã de sobre
def about_screen(root):
    for widget in root.winfo_children():
        widget.destroy()  # Remove todos os widgets existentes

    tk.Label(
        root,
        text="===== Sobre o BLACKJACK 21 =====\n\n"
             "Programa desenvolvido ao longo do primeiro semestre da Unidade Curricular\n"
             "de Programação por Objetos da Licenciatura de Engenharia Informática (LEI)\n\n"
             "Versão: 01.01 – Desenvolvido no Efólio A\n"
             " - Definição das linhas orientadoras do jogo BlackJack em linguagem Python\n\n"
             "Versão: 01.02 – Desenvolvido no Efólio B\n"
             " - Separação de classes por ficheiros .py.\n"
             " - Implementação de regras do jogo.\n"
             " - Implementação do menu.\n\n"
             "Versão: 01.03 (atual) – Desenvolvido no Efólio Global\n"
             " - Criação de ambiente gráfico usando TKinter\n"
             " - Implementação de novas bibliotecas 'pip' conforme AF7\n\n"
             "Aluno nº 2300163 – Luís Pereira\n"
             "Unidade Curricular – Programação por Objetos (21093)\n"
             "Licenciatura de Engenharia Informática (LEI)\n"
             "Ano letivo 2024/2025\n"
             "Universidade Aberta (UAb)\n\n"
             "Pressione 'Fechar' para retornar ao menu.",
        justify="left",
        font=("Helvetica", 10),
    ).pack(pady=10)